/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.extra;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.aksw.jena_sparql_api.cache.extra.CacheCoreEx;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.extra.CacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jena_sparql_api.cache.extra.CacheResourceCacheEntry;

public class CacheExImpl
implements CacheEx {
    private CacheCoreEx cacheCore;

    public CacheExImpl(CacheCoreEx cacheCore) {
        this.cacheCore = cacheCore;
    }

    public void write(String service, String queryString, ResultSet resultSet) {
        try {
            this._write(service, queryString, resultSet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, final ResultSet resultSet) throws IOException {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        new Thread(new Runnable(){

            public void run() {
                ResultSetFormatter.outputAsXML((OutputStream)out, (ResultSet)resultSet);
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        this.cacheCore.write(service, queryString, in);
    }

    public void write(String service, Query query, ResultSet resultSet) {
        this.write(service, query.toString(), resultSet);
    }

    public void write(String service, String queryString, Model model) {
        try {
            this._write(service, queryString, model);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, final Model model) throws IOException {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        new Thread(new Runnable(){

            public void run() {
                model.write((OutputStream)out, "N-TRIPLES");
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        this.cacheCore.write(service, queryString, in);
    }

    public void write(String service, Query query, Model model) {
        this.write(service, query.toString(), model);
    }

    public CacheResource lookup(String service, String queryString) {
        CacheEntry cacheEntry = this.cacheCore.lookup(service, queryString);
        return cacheEntry == null ? null : new CacheResourceCacheEntry(cacheEntry);
    }

    public CacheResource lookup(String service, Query query) {
        CacheEntry cacheEntry = this.cacheCore.lookup(service, query.toString());
        return cacheEntry == null ? null : new CacheResourceCacheEntry(cacheEntry);
    }

    public void write(String service, String queryString, boolean value) {
        try {
            this._write(service, queryString, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, boolean value) throws IOException {
        this.cacheCore.write(service, queryString, new ByteArrayInputStream(String.valueOf(value).getBytes()));
    }

    public void write(String service, Query query, boolean value) {
        this.write(service, query.toString(), value);
    }
}

