package org.aksw.jena_sparql_api.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.aksw.commons.collections.PrefetchIterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.syntax.Template;

/**
 * @author Claus Stadler
 *         <p/>
 *         Date: 11/5/11
 *         Time: 2:16 PM
 */
public class ConstructIterator
    extends PrefetchIterator<Triple>
{
    private Template template;
    private ResultSet rs;

    public ConstructIterator(Template template, ResultSet rs)
    {
        this.template = template;
        this.rs = rs;
    }


    /**
     * Returns an iterator over the triples generated by instancing the
     * template with each of the result set rows.
     *
     * Duplicates are not removed; this can be achieved by
     * wrapping this iterator with a UniqueIterator.
     *
     * TODO We could do some optimization by factoring out constant triples from the
     * template.
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Iterator<Triple> prefetch() throws Exception {

        // Build each template substitution as triples.
        while(rs.hasNext()) {
            Set<Triple> set = new HashSet<Triple>();
            Map<Node, Node> bNodeMap = new HashMap<Node, Node>();
            Binding binding = rs.nextBinding();
            template.subst(set, bNodeMap, binding);

            return set.iterator();
        }

        return null;
    }

    @Override
    public void close() {
    	super.close();
    	//rs.close();
    }
}
