/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.retry.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDecorator;
import org.aksw.jena_sparql_api.retry.core.QueryExecutionRetry;

public class QueryExecutionFactoryRetry
extends QueryExecutionFactoryDecorator {
    private int retryCount;
    private long retryDelayInMs;

    public QueryExecutionFactoryRetry(QueryExecutionFactory decoratee, int retryCount, long retryDelayInMs) {
        super(decoratee);
        this.retryCount = retryCount;
        this.retryDelayInMs = retryDelayInMs;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        QueryExecution qe = super.createQueryExecution(query);
        QueryExecutionRetry result = new QueryExecutionRetry(qe, this.retryCount, this.retryDelayInMs);
        return result;
    }

    @Override
    public QueryExecution createQueryExecution(String queryString) {
        QueryExecution qe = super.createQueryExecution(queryString);
        QueryExecutionRetry result = new QueryExecutionRetry(qe, this.retryCount, this.retryDelayInMs);
        return result;
    }
}

