/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.extra;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtils.class);

    public static <T> void executeSetArgs(PreparedStatement stmt, Object ... args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            stmt.setObject(i + 1, args[i]);
        }
        int n = stmt.getParameterMetaData().getParameterCount();
        for (int i = args.length; i < n; ++i) {
            stmt.setObject(i + 1, null);
        }
    }

    public static <T> T execute(Connection conn, String sql, Class<T> clazz, Object ... args) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        T result = SqlUtils.execute(stmt, clazz, args);
        stmt.close();
        return result;
    }

    public static ResultSet executeCore(Connection conn, String sql, Object ... args) throws SQLException {
        logger.trace("Executing statement '" + sql + "' with args " + Arrays.asList(args));
        PreparedStatement stmt = conn.prepareStatement(sql);
        SqlUtils.executeSetArgs(stmt, args);
        ResultSet result = stmt.executeQuery();
        return result;
    }

    public static ResultSet execute(PreparedStatement stmt, Object ... args) throws SQLException {
        SqlUtils.executeSetArgs(stmt, args);
        ResultSet result = stmt.executeQuery();
        return result;
    }

    public static <T> T execute(PreparedStatement stmt, Class<T> clazz, Object ... args) throws SQLException {
        SqlUtils.executeSetArgs(stmt, args);
        T result = null;
        if (clazz == null || Void.class.equals(clazz)) {
            stmt.execute();
        } else {
            ResultSet rs = stmt.executeQuery();
            result = SqlUtils.single(rs, clazz);
            rs.close();
        }
        return result;
    }

    public static <T> List<T> executeList(Connection conn, String sql, Class<T> clazz, Object ... args) throws SQLException {
        logger.trace("Executing statement '" + sql + "' with args " + Arrays.asList(args));
        PreparedStatement stmt = conn.prepareStatement(sql);
        List<T> result = SqlUtils.executeList(stmt, clazz, args);
        stmt.close();
        return result;
    }

    public static <T> List<T> executeList(PreparedStatement stmt, Class<T> clazz, Object ... args) throws SQLException {
        SqlUtils.executeSetArgs(stmt, args);
        ResultSet rs = stmt.executeQuery();
        List<T> result = SqlUtils.list(rs, clazz);
        return result;
    }

    public static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.toString());
        }
    }

    public static <T> T single(ResultSet rs, Class<T> clazz) throws SQLException {
        return SqlUtils.single(rs, clazz, true);
    }

    public static <T> T single(ResultSet rs, Class<T> clazz, boolean bClose) throws SQLException {
        if (rs.getMetaData().getColumnCount() != 1) {
            throw new RuntimeException("only a single column expected");
        }
        Object result = null;
        if (rs.next()) {
            Object o;
            result = o = rs.getObject(1);
            if (rs.next()) {
                throw new RuntimeException("only at most 1 row expected");
            }
        }
        if (bClose) {
            rs.close();
        }
        return (T)result;
    }

    public static <T> List<T> list(ResultSet rs, Class<T> clazz) throws SQLException {
        return SqlUtils.list(rs, clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> list(ResultSet rs, Class<T> clazz, boolean bClose) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            while (rs.next()) {
                Object o;
                Object item = o = rs.getObject(1);
                result.add(item);
            }
        }
        finally {
            if (bClose) {
                rs.close();
            }
        }
        return result;
    }
}

