/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.retry.core;

import java.util.concurrent.Callable;
import org.aksw.jena_sparql_api.delay.extra.Delayer;
import org.aksw.jena_sparql_api.delay.extra.DelayerDefault;
import org.aksw.jena_sparql_api.retry.core.QueryExecutionRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallableRetry<T>
implements Callable<T> {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionRetry.class);
    private Callable<T> callable;
    private int retryCount;
    private Delayer retryDelayer;

    public CallableRetry(Callable<T> callable, int retryCount, long retryDelayInMs) {
        this(callable, retryCount, new DelayerDefault(retryDelayInMs));
    }

    public CallableRetry(Callable<T> callable, int retryCount, Delayer retryDelayer) {
        this.callable = callable;
        this.retryCount = retryCount;
        this.retryDelayer = retryDelayer;
    }

    @Override
    public T call() throws Exception {
        int errorCount = 0;
        while (true) {
            try {
                this.retryDelayer.doDelay();
                T result = this.callable.call();
                return result;
            }
            catch (Exception e) {
                logger.warn("Failure " + ++errorCount + "/" + this.retryCount + " [" + e.getMessage() + "]");
                if (errorCount < this.retryCount) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }
}

