/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.extra;

import com.hp.hpl.jena.query.Query;
import org.aksw.commons.collections.SinglePrefetchIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginationQueryIterator
extends SinglePrefetchIterator<Query> {
    private long nextOffset;
    private Long nextRemaining;
    private Query query;
    private long pageSize;

    public PaginationQueryIterator(Query query, long pageSize) {
        this.query = query;
        this.pageSize = pageSize;
        this.nextOffset = query.getOffset() == Long.MIN_VALUE ? 0L : query.getOffset();
        this.nextRemaining = query.getLimit() == Long.MIN_VALUE ? null : Long.valueOf(query.getLimit());
    }

    public Query prefetch() {
        if (this.nextOffset == 0L) {
            this.query.setOffset(Long.MIN_VALUE);
        } else {
            this.query.setOffset(this.nextOffset);
        }
        if (this.nextRemaining == null) {
            this.query.setLimit(this.pageSize);
            this.nextOffset += this.pageSize;
        } else {
            long limit = Math.min(this.pageSize, this.nextRemaining);
            this.nextOffset += limit;
            this.nextRemaining = this.nextRemaining - limit;
            if (limit == 0L) {
                return (Query)this.finish();
            }
            this.query.setLimit(limit);
        }
        return this.query;
    }
}

