/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorResultSet;
import java.util.Iterator;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionIterated;
import org.apache.jena.atlas.lib.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetPaginated
extends PrefetchIterator<Binding>
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(ResultSetPaginated.class);
    private QueryExecutionFactory service;
    private QueryExecutionIterated execution;
    private Iterator<Query> queryIterator;
    private boolean stopOnEmptyResult = true;
    private ResultSet currentResultSet = null;

    public ResultSetPaginated(QueryExecutionIterated execution, QueryExecutionFactory service, Iterator<Query> queryIterator, boolean stopOnEmptyResult) {
        this.execution = execution;
        this.service = service;
        this.queryIterator = queryIterator;
    }

    public ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    protected QueryIteratorResultSet prefetch() throws Exception {
        while (this.queryIterator.hasNext()) {
            Query query = this.queryIterator.next();
            if (query == null) {
                throw new RuntimeException("Null query encountered in iterator");
            }
            QueryExecution qe = this.service.createQueryExecution(query);
            if (this.execution != null) {
                this.execution._setDecoratee(qe);
            }
            logger.trace("Executing: " + query);
            this.currentResultSet = qe.execSelect();
            if (!this.currentResultSet.hasNext()) {
                if (!this.stopOnEmptyResult) continue;
                return null;
            }
            return new QueryIteratorResultSet(this.currentResultSet);
        }
        return null;
    }

    public void close() {
        if (this.execution != null) {
            this.execution.close();
        }
    }
}

