/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.sparql_path.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.jena_sparql_api.retry.core.QueryExecutionFactoryRetry;
import org.aksw.jena_sparql_api.sparql_path.core.SparqlServiceFactory;

public class SparqlServiceFactoryImpl
implements SparqlServiceFactory {
    private Map<String, QueryExecutionFactory> keyToSparqlService = new HashMap<String, QueryExecutionFactory>();
    private CacheFrontend cacheFrontend = null;

    public SparqlServiceFactoryImpl(CacheFrontend cacheFrontend) {
        this.cacheFrontend = cacheFrontend;
    }

    @Override
    public QueryExecutionFactory createSparqlService(String serviceUri, Collection<String> defaultGraphUris) {
        TreeSet<String> tmp = new TreeSet<String>(defaultGraphUris);
        String key = serviceUri + tmp;
        QueryExecutionFactory result = this.keyToSparqlService.get(key);
        if (result == null) {
            result = new QueryExecutionFactoryHttp(serviceUri, defaultGraphUris);
            result = new QueryExecutionFactoryRetry(result, 3, 5000L);
            if (this.cacheFrontend != null) {
                result = new QueryExecutionFactoryCacheEx(result, this.cacheFrontend);
            }
            result = new QueryExecutionFactoryPaginated(result);
            this.keyToSparqlService.put(key, result);
        }
        return result;
    }
}

