/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.google.common.collect.Iterators;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.jena_sparql_api.concept_cache.ConceptMap;
import org.aksw.jena_sparql_api.concept_cache.IteratorResultSetBinding;
import org.aksw.jena_sparql_api.concept_cache.ResultSetUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionDecoratorBase;

public class QueryExecutionConceptCache
extends QueryExecutionDecoratorBase<QueryExecution> {
    private ConceptMap conceptMap;
    private Query query;
    private Set<Var> indexVars;
    private long indexResultSetSizeThreshold = 20000L;

    public QueryExecutionConceptCache(QueryExecution decoratee, ConceptMap conceptMap, Query query, Set<Var> indexVars) {
        super(decoratee);
        this.conceptMap = conceptMap;
        this.query = query;
        this.indexVars = indexVars;
    }

    public static boolean canIndexQuery(Query query, long rsSize) {
        long limit = query.getLimit();
        long offset = query.getOffset();
        boolean isZeroOffset = offset == Long.MIN_VALUE || offset == 0L;
        boolean isCompleteResult = limit == Long.MIN_VALUE || rsSize < limit;
        boolean result = isZeroOffset && isCompleteResult;
        return result;
    }

    public ResultSet tryIndex(ResultSet rs) {
        ResultSetRewindable result = ResultSetFactory.copyResults((ResultSet)rs);
        long rsSize = result.size();
        boolean canIndex = QueryExecutionConceptCache.canIndexQuery(this.query, rsSize);
        if (canIndex) {
            ResultSet cacheRs = ResultSetUtils.project((ResultSet)result, this.indexVars, true);
            this.conceptMap.index(this.query, cacheRs);
        }
        return result;
    }

    public ResultSet execSelect() {
        ResultSet result;
        boolean exceededThreshold;
        ResultSet physicalRs = this.decoratee.execSelect();
        List varNames = physicalRs.getResultVars();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        int i = 0;
        while ((long)i < this.indexResultSetSizeThreshold && physicalRs.hasNext()) {
            Binding binding = physicalRs.nextBinding();
            bindings.add(binding);
            ++i;
        }
        boolean bl = exceededThreshold = (long)i >= this.indexResultSetSizeThreshold;
        if (exceededThreshold) {
            Iterator it = Iterators.concat(bindings.iterator(), (Iterator)new IteratorResultSetBinding(physicalRs));
            result = new ResultSetStream(varNames, null, it);
        } else {
            ResultSetStream tmp = new ResultSetStream(varNames, null, bindings.iterator());
            result = this.tryIndex((ResultSet)tmp);
        }
        return result;
    }
}

