/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.optimize.Optimize;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterPlacement;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import com.hp.hpl.jena.sparql.graph.NodeTransformLib;
import java.util.HashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.concept_cache.OpUtils;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;

public class OpIndexTests {
    public static void main(String[] args) {
        String queryString = "Select Distinct ?s { { ?s a <http://Foo> } Union { ?s a <http://Bar> } Union { ?s a <http://Baz> } . Filter(?s = <http://Bar>) }";
        Query query = QueryFactory.create((String)queryString);
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        TransformFilterPlacement transform = new TransformFilterPlacement();
        op = Optimize.apply((Transform)transform, (Op)op);
        HashMap<Var, Var> varMap = new HashMap<Var, Var>();
        varMap.put(Var.alloc((String)"s"), Var.alloc((String)"x"));
        NodeTransformRenameMap nodeTransform = new NodeTransformRenameMap(varMap);
        op = NodeTransformLib.transform((NodeTransform)nodeTransform, (Op)op);
        System.out.println(op);
        Map<Op, Op> parentMap = OpUtils.parentMap(op);
        for (Map.Entry<Op, Op> entry : parentMap.entrySet()) {
            Op v = entry.getKey();
            if (!(v instanceof OpQuadPattern)) continue;
            System.out.println("QuadPattern: " + v);
        }
    }
}

