/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.CartesianProductIterator;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.jena_sparql_api.concept_cache.IteratorBindingJoin;

class IteratorJoin<K>
extends PrefetchIterator<Binding> {
    private Iterator<K> itKey;
    private Multimap<K, Binding> a;
    private Multimap<K, Binding> b;

    public IteratorJoin(Iterator<K> itKey, Multimap<K, Binding> a, Multimap<K, Binding> b) {
        this.itKey = itKey;
        this.a = a;
        this.b = b;
    }

    protected Iterator<Binding> prefetch() throws Exception {
        IteratorBindingJoin result = null;
        while (this.itKey.hasNext()) {
            K key = this.itKey.next();
            Collection as = this.a.get(key);
            Collection bs = this.b.get(key);
            if (as.isEmpty() || bs.isEmpty()) continue;
            CartesianProductIterator tmp = new CartesianProductIterator(new Iterable[]{as, bs});
            result = new IteratorBindingJoin((Iterator<List<Binding>>)tmp);
            break;
        }
        return result;
    }
}

