/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache.domain;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.QuadUtils;

public class QfpSummary {
    private Set<Quad> quads;
    private Set<Set<Expr>> filterCnf;

    public QfpSummary(Set<Quad> quads, Set<Set<Expr>> filterCnf) {
        this.quads = quads;
        this.filterCnf = filterCnf;
    }

    public QfpSummary copySubstitute(Map<? extends Node, ? extends Node> varMap) {
        HashSet<Quad> newQuads = new HashSet<Quad>();
        for (Quad quad : this.quads) {
            Quad newQuad = QuadUtils.copySubstitute((Quad)quad, varMap);
            newQuads.add(newQuad);
        }
        NodeTransformRenameMap transform = new NodeTransformRenameMap(varMap);
        Set newFilterCnf = ClauseUtils.applyNodeTransformSet(this.filterCnf, (NodeTransform)transform);
        QfpSummary result = new QfpSummary(newQuads, newFilterCnf);
        return result;
    }

    public Set<Quad> getQuads() {
        return this.quads;
    }

    public Set<Set<Expr>> getFilterCnf() {
        return this.filterCnf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filterCnf == null ? 0 : this.filterCnf.hashCode());
        result = 31 * result + (this.quads == null ? 0 : this.quads.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QfpSummary other = (QfpSummary)obj;
        if (this.filterCnf == null ? other.filterCnf != null : !this.filterCnf.equals(other.filterCnf)) {
            return false;
        }
        return !(this.quads == null ? other.quads != null : !this.quads.equals(other.quads));
    }

    public String toString() {
        return "QfpSummary [quads=" + this.quads + ", filterCnf=" + this.filterCnf + "]";
    }
}

