/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.table.TableN;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MapUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;

class Utils2 {
    Utils2() {
    }

    public static Binding transformKeys(Binding binding, NodeTransform transform) {
        Iterator it = binding.vars();
        BindingHashMap result = new BindingHashMap();
        while (it.hasNext()) {
            Var o = (Var)it.next();
            Node node = binding.get(o);
            Var n = (Var)transform.convert((Node)o);
            result.add(n, node);
        }
        return result;
    }

    public static Table transform(Table table, NodeTransform transform) {
        List oldVars = table.getVars();
        ArrayList<Var> newVars = new ArrayList<Var>(oldVars.size());
        for (Var o : oldVars) {
            Var n = (Var)transform.convert((Node)o);
            newVars.add(n);
        }
        TableN result = new TableN(newVars);
        Iterator it = table.rows();
        while (it.hasNext()) {
            Binding o = (Binding)it.next();
            Binding n = Utils2.transformKeys(o, transform);
            result.addBinding(n);
        }
        return result;
    }

    public static Set<Var> getCooccurrentVars(Set<Var> vars, Iterable<Quad> quads) {
        HashSet<Var> result = new HashSet<Var>();
        for (Quad quad : quads) {
            Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
            Sets.SetView intersection = Sets.intersection(vars, (Set)quadVars);
            if (intersection.isEmpty()) continue;
            result.addAll(quadVars);
        }
        return result;
    }

    public static Multimap<Var, Var> getCooccurrentVarMap(Set<Var> vars, Iterable<Quad> quads) {
        HashMultimap result = HashMultimap.create();
        for (Quad quad : quads) {
            Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
            Sets.SetView intersection = Sets.intersection(vars, (Set)quadVars);
            for (Var v : intersection) {
                Sets.SetView diff = Sets.difference((Set)quadVars, Collections.singleton(v));
                result.putAll((Object)v, (Iterable)diff);
            }
        }
        return result;
    }

    public static Map<Var, Var> createVarMap(Quad source, Quad target) {
        HashMap<Var, Var> result = new HashMap<Var, Var>();
        for (int i = 0; i < 4; ++i) {
            Var t;
            Var s = (Var)QuadUtils.getNode((Quad)source, (int)i);
            Map<Var, Var> cand = Collections.singletonMap(s, t = (Var)QuadUtils.getNode((Quad)target, (int)i));
            boolean isCompatible = MapUtils.isPartiallyCompatible(cand, result);
            if (!isCompatible) {
                result = null;
                break;
            }
            result.put(s, t);
        }
        return result;
    }
}

