/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

public class CartesianVector {
    private int n;
    private int[] vector;

    public CartesianVector(int n, int k) {
        this.n = n;
        this.vector = new int[k];
        for (int i = 0; i < k; ++i) {
            this.vector[i] = 0;
        }
    }

    public int nextIndex(int i) {
        while (i >= 0 && this.vector[i] + 1 > this.n - 1) {
            --i;
        }
        return i;
    }

    public int nextIndex() {
        int result = this.nextIndex(this.vector.length - 1);
        return result;
    }

    public boolean inc(int i) {
        boolean result;
        boolean bl = result = (i = this.nextIndex(i)) >= 0;
        if (result) {
            int n = i;
            this.vector[n] = this.vector[n] + 1;
            for (int j = i + 1; j < this.vector.length; ++j) {
                this.vector[j] = 0;
            }
        } else {
            this.vector = null;
        }
        return result;
    }

    public boolean inc() {
        boolean result = this.inc(this.vector.length - 1);
        return result;
    }

    public int[] vector() {
        return this.vector;
    }
}

