/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.restriction;

import java.util.Collection;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.aksw.commons.util.strings.StringUtils;

public class PrefixSet {
    private NavigableSet<String> prefixes;

    public PrefixSet() {
        this.prefixes = new TreeSet<String>();
    }

    public PrefixSet(String ... strings) {
        this.prefixes = new TreeSet<String>();
        for (String string : strings) {
            this.prefixes.add(string);
        }
    }

    public PrefixSet(NavigableSet<String> prefixes) {
        this.prefixes = prefixes;
    }

    public PrefixSet(PrefixSet uriPrefixes) {
        this(new TreeSet<String>((SortedSet<String>)uriPrefixes.prefixes));
    }

    public void addAll(Collection<String> prefixes) {
        this.prefixes.addAll(prefixes);
    }

    public void addAll(PrefixSet other) {
        this.addAll(other.getSet());
    }

    public NavigableSet<String> getSet() {
        return this.prefixes;
    }

    public boolean isEmpty() {
        return this.prefixes.isEmpty();
    }

    public String toString() {
        return "PrefixSet [prefixes=" + this.prefixes + "]";
    }

    public boolean containsPrefixOf(String value) {
        return StringUtils.longestPrefixLookup((String)value, this.prefixes) != null;
    }

    public boolean isPrefixForItem(String prefix) {
        return this.getShortestMatch(prefix) != null;
    }

    public String getShortestMatch(String prefix) {
        return StringUtils.shortestMatchLookup((String)prefix, (boolean)true, this.prefixes);
    }

    public static void main(String[] args) {
        PrefixSet x = new PrefixSet();
        x.getSet().add("aaa");
        x.getSet().add("bbb");
        x.getSet().add("b");
        x.getSet().add("ccc");
        x.getSet().add("cccd");
        x.getSet().add("cccde");
    }

    public void removeAll(Collection<String> ps) {
        this.prefixes.removeAll(ps);
    }

    public void add(String s) {
        this.prefixes.add(s);
    }

    public Set<String> getPrefixesOf(String s) {
        return StringUtils.getAllPrefixes((String)s, (boolean)true, this.prefixes);
    }

    public Set<String> getPrefixesOf(String s, boolean inclusive) {
        return StringUtils.getAllPrefixes((String)s, (boolean)inclusive, this.prefixes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.prefixes == null ? 0 : this.prefixes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixSet other = (PrefixSet)obj;
        return !(this.prefixes == null ? other.prefixes != null : !this.prefixes.equals(other.prefixes));
    }
}

