/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache.domain;

import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.aksw.jena_sparql_api.utils.NfUtils;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;

public class QuadFilterPatternCanonical {
    private Set<Quad> quads;
    private Set<Set<Expr>> filterCnf;

    public QuadFilterPatternCanonical(Set<Quad> quads, Set<Set<Expr>> filterCnf) {
        this.quads = quads;
        this.filterCnf = filterCnf;
    }

    public Op toOp() {
        OpNull result;
        ExprList exprs = CnfUtils.toExprList(this.filterCnf);
        QuadPattern qp = QuadPatternUtils.create(this.quads);
        Map index = QuadPatternUtils.indexBasicPattern((Iterable)qp);
        ArrayList<OpQuadPattern> opqs = new ArrayList<OpQuadPattern>();
        for (Map.Entry entry : index.entrySet()) {
            OpQuadPattern oqp = new OpQuadPattern((Node)entry.getKey(), (BasicPattern)entry.getValue());
            opqs.add(oqp);
        }
        if (opqs.isEmpty()) {
            result = OpNull.create();
        } else if (opqs.size() == 1) {
            result = (Op)opqs.iterator().next();
        } else {
            OpSequence op = OpSequence.create();
            for (OpQuadPattern item : opqs) {
                op.add((Op)item);
            }
            result = op;
        }
        if (!exprs.isEmpty()) {
            result = OpFilter.filter((ExprList)exprs, (Op)result);
        }
        return result;
    }

    public Set<Quad> getQuads() {
        return this.quads;
    }

    public Set<Set<Expr>> getFilterCnf() {
        return this.filterCnf;
    }

    public Set<Var> getVarsMentioned() {
        Set result = QuadUtils.getVarsMentioned(this.quads);
        Set extra = NfUtils.getVarsMentioned(this.filterCnf);
        result.addAll(extra);
        return result;
    }

    public QuadFilterPatternCanonical applyNodeTransform(NodeTransform nodeTransform) {
        Set newQuads = QuadUtils.applyNodeTransform(this.quads, (NodeTransform)nodeTransform);
        Set newExprs = ClauseUtils.applyNodeTransformSet(this.filterCnf, (NodeTransform)nodeTransform);
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(newQuads, newExprs);
        return result;
    }

    public QuadFilterPatternCanonical diff(QuadFilterPatternCanonical other) {
        HashSet<Quad> newQuads = new HashSet<Quad>((Collection<Quad>)Sets.difference(other.quads, this.quads));
        HashSet<Set<Expr>> newCnf = new HashSet<Set<Expr>>((Collection<Set<Expr>>)Sets.difference(other.filterCnf, this.filterCnf));
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(newQuads, newCnf);
        return result;
    }

    public boolean isSubsumedBy(QuadFilterPatternCanonical other) {
        boolean containsAllQuads = other.getQuads().containsAll(this.quads);
        boolean result = containsAllQuads ? CnfUtils.isSubsumedBy(other.filterCnf, this.filterCnf) : false;
        return result;
    }

    public String toString() {
        return "QuadFilterPatternNorm [quads=" + this.quads + ", filterCnf=" + this.filterCnf + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filterCnf == null ? 0 : this.filterCnf.hashCode());
        result = 31 * result + (this.quads == null ? 0 : this.quads.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuadFilterPatternCanonical other = (QuadFilterPatternCanonical)obj;
        if (this.filterCnf == null ? other.filterCnf != null : !this.filterCnf.equals(other.filterCnf)) {
            return false;
        }
        return !(this.quads == null ? other.quads != null : !this.quads.equals(other.quads));
    }
}

