/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache.domain;

import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.ArrayList;
import java.util.List;
import org.aksw.jena_sparql_api.utils.QuadUtils;

public class QuadFilterPattern {
    private List<Quad> quads;
    private Expr expr;

    public QuadFilterPattern(List<Quad> quads, Expr expr) {
        this.quads = quads;
        this.expr = expr;
    }

    public List<Quad> getQuads() {
        return this.quads;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public QuadFilterPattern applyNodeTransform(NodeTransform nodeTransform) {
        ArrayList<Quad> newQuads = new ArrayList<Quad>(this.quads.size());
        for (Quad quad : this.quads) {
            Quad newQuad = QuadUtils.applyNodeTransform((Quad)quad, (NodeTransform)nodeTransform);
            newQuads.add(newQuad);
        }
        Expr newExpr = this.expr.applyNodeTransform(nodeTransform);
        QuadFilterPattern result = new QuadFilterPattern(newQuads, newExpr);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.quads == null ? 0 : this.quads.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuadFilterPattern other = (QuadFilterPattern)obj;
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return !(this.quads == null ? other.quads != null : !this.quads.equals(other.quads));
    }

    public String toString() {
        return "QuadFilterPattern [quads=" + this.quads + ", expr=" + this.expr + "]";
    }
}

