/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.google.common.collect.AbstractIterator;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aksw.commons.collections.MapUtils;
import org.aksw.jena_sparql_api.concept_cache.CombinatoricsVector;
import org.aksw.jena_sparql_api.concept_cache.QuadGroup;
import org.aksw.jena_sparql_api.concept_cache.Utils2;

class IteratorVarMapQuadGroup
extends AbstractIterator<Map<Var, Var>> {
    private List<Quad> sourceQuads;
    private List<Quad> targetQuads;
    private Map<Var, Var> baseSolution;
    private CombinatoricsVector combi;
    private List<Map<Var, Var>> partialSolutions;
    private int nextInc;

    public IteratorVarMapQuadGroup(List<Quad> sourceQuads, List<Quad> targetQuads, Map<Var, Var> baseSolution) {
        this.sourceQuads = sourceQuads;
        this.targetQuads = targetQuads;
        this.baseSolution = baseSolution;
        this.combi = new CombinatoricsVector(targetQuads.size(), sourceQuads.size());
        this.partialSolutions = new ArrayList<Map<Var, Var>>(sourceQuads.size());
        this.update(0);
    }

    private boolean update(int i) {
        int[] vector = this.combi.vector();
        while (i < vector.length) {
            int targetIndex;
            Quad targetQuad;
            Map<Var, Var> priorSolution = i > 0 ? this.partialSolutions.get(i - 1) : this.baseSolution;
            Quad sourceQuad = this.sourceQuads.get(i);
            Map<Var, Var> nextSolution = IteratorVarMapQuadGroup.validate(sourceQuad, targetQuad = this.targetQuads.get(targetIndex = vector[i]), priorSolution);
            if (nextSolution == null) break;
            this.partialSolutions.add(nextSolution);
            ++i;
        }
        this.nextInc = this.combi.nextIndex(i - 1);
        boolean result = i == vector.length;
        return result;
    }

    private boolean inc() {
        boolean result;
        this.combi.inc(this.nextInc);
        if (this.nextInc >= 0) {
            while (this.partialSolutions.size() > this.nextInc) {
                this.partialSolutions.remove(this.partialSolutions.size() - 1);
            }
            result = this.update(this.nextInc);
        } else {
            result = false;
        }
        return result;
    }

    public static Map<Var, Var> validate(Quad sourceQuad, Quad targetQuad, Map<Var, Var> partialSolution) {
        boolean isCompatible;
        Map<Var, Var> result = Utils2.createVarMap(sourceQuad, targetQuad);
        if (result != null && (isCompatible = MapUtils.isPartiallyCompatible(result, partialSolution))) {
            result.putAll(partialSolution);
        }
        return result;
    }

    protected Map<Var, Var> computeNext() {
        Map<Var, Var> result;
        while (this.combi.vector() != null && this.partialSolutions.size() != this.sourceQuads.size()) {
            this.inc();
        }
        if (this.combi.vector() == null) {
            result = (Map<Var, Var>)this.endOfData();
        } else {
            result = this.partialSolutions.get(this.partialSolutions.size() - 1);
            this.inc();
        }
        return result;
    }

    public static Iterator<Map<Var, Var>> create(QuadGroup quadGroup, Map<Var, Var> baseSolution) {
        IteratorVarMapQuadGroup result = new IteratorVarMapQuadGroup(new ArrayList<Quad>(quadGroup.getCandQuads()), new ArrayList<Quad>(quadGroup.getQueryQuads()), baseSolution);
        return result;
    }
}

