/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_OneOf;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.collections.MapUtils;
import org.aksw.commons.collections.multimaps.BiHashMultimap;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.jena_sparql_api.concept_cache.CacheHit;
import org.aksw.jena_sparql_api.concept_cache.CacheResult;
import org.aksw.jena_sparql_api.concept_cache.IterableVarMapQuadGroup;
import org.aksw.jena_sparql_api.concept_cache.IteratorVarMapQuadGroups;
import org.aksw.jena_sparql_api.concept_cache.QuadGroup;
import org.aksw.jena_sparql_api.concept_cache.Utils2;
import org.aksw.jena_sparql_api.concept_cache.VarUtils;
import org.aksw.jena_sparql_api.concept_cache.domain.PatternSummary;
import org.aksw.jena_sparql_api.concept_cache.domain.QuadFilterPattern;
import org.aksw.jena_sparql_api.concept_cache.domain.QuadFilterPatternCanonical;
import org.aksw.jena_sparql_api.concept_cache.domain.VarOccurrence;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.jena_sparql_api.utils.ReplaceConstants;
import org.apache.commons.math3.util.CombinatoricsUtils;

class ConceptMap {
    private IBiSetMultimap<Set<Set<Expr>>, PatternSummary> quadCnfToSummary = new BiHashMultimap();
    private Map<PatternSummary, Map<Set<Var>, Table>> cacheData = new HashMap<PatternSummary, Map<Set<Var>, Table>>();

    ConceptMap() {
    }

    public static Set<Set<Expr>> normalize(Quad quad, Set<Set<Expr>> cnf) {
        List<Var> componentVars = Arrays.asList(Var.alloc((String)"g"), Var.alloc((String)"s"), Var.alloc((String)"p"), Var.alloc((String)"o"));
        HashMap<Var, Var> renameMap = new HashMap<Var, Var>();
        HashSet<Set<E_Equals>> extra = new HashSet<Set<E_Equals>>();
        for (int i = 0; i < 4; ++i) {
            Var quadVar = (Var)QuadUtils.getNode((Quad)quad, (int)i);
            Var componentVar = componentVars.get(i);
            Var priorComponentVar = (Var)renameMap.get(quadVar);
            if (priorComponentVar != null) {
                extra.add(Collections.singleton(new E_Equals((Expr)new ExprVar(priorComponentVar), (Expr)new ExprVar(componentVar))));
                continue;
            }
            renameMap.put(quadVar, componentVar);
        }
        NodeTransformRenameMap transform = new NodeTransformRenameMap(renameMap);
        Set result = ClauseUtils.applyNodeTransformSet(cnf, (NodeTransform)transform);
        result.addAll(extra);
        return result;
    }

    public static Set<Set<Expr>> add(Quad quad, Set<Set<Expr>> cnf) {
        HashSet<Set<Expr>> result = new HashSet<Set<Expr>>();
        for (Set<Expr> clause : cnf) {
            Set clauseVars = ClauseUtils.getVarsMentioned(clause);
            Set exprVars = QuadUtils.getVarsMentioned((Quad)quad);
            boolean isApplicable = exprVars.containsAll(clauseVars);
            if (!isApplicable) continue;
            result.add(clause);
        }
        return result;
    }

    public static QuadFilterPattern transform(Query query) {
        OpFilter opFilter;
        Op subOp;
        QuadFilterPattern result = null;
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        if ((op = ReplaceConstants.replace((Op)op)) instanceof OpDistinct) {
            op = ((OpDistinct)op).getSubOp();
        }
        if (op instanceof OpProject) {
            op = ((OpProject)op).getSubOp();
        }
        if ((subOp = (opFilter = op instanceof OpFilter ? (OpFilter)op : (OpFilter)OpFilter.filter((Expr)NodeValue.TRUE, (Op)op)).getSubOp()) instanceof OpQuadPattern) {
            OpQuadPattern opQuadPattern = (OpQuadPattern)opFilter.getSubOp();
            QuadPattern quadPattern = opQuadPattern.getPattern();
            List quads = quadPattern.getList();
            ExprList exprs = opFilter.getExprs();
            Expr expr = ExprUtils.andifyBalanced((Iterable)exprs);
            result = new QuadFilterPattern(quads, expr);
        }
        return result;
    }

    public PatternSummary summarize(QuadFilterPattern originalPattern) {
        Expr expr = originalPattern.getExpr();
        HashSet<Quad> quads = new HashSet<Quad>(originalPattern.getQuads());
        Set filterCnf = CnfUtils.toSetCnf((Expr)expr);
        BiHashMultimap quadToCnf = new BiHashMultimap();
        for (Quad quad : quads) {
            Set quadVars = QuadUtils.getVarsMentioned((Quad)quad);
            HashSet<Set<Expr>> cnf = new HashSet<Set<Expr>>();
            for (Set clause : filterCnf) {
                Set clauseVars = ClauseUtils.getVarsMentioned((Iterable)clause);
                boolean containsAll = quadVars.containsAll(clauseVars);
                if (!containsAll) continue;
                cnf.add(clause);
            }
            Set<Set<Expr>> quadCnf = ConceptMap.normalize(quad, cnf);
            quadToCnf.put((Object)quad, quadCnf);
        }
        BiHashMultimap varOccurrences = new BiHashMultimap();
        for (Quad quad : quads) {
            Set quadCnf = (Set)quadToCnf.get((Object)quad).iterator().next();
            for (int j = 0; j < 4; ++j) {
                Var var = (Var)QuadUtils.getNode((Quad)quad, (int)j);
                VarOccurrence varOccurence = new VarOccurrence(quadCnf, j);
                varOccurrences.put((Object)var, (Object)varOccurence);
            }
        }
        boolean pruneVarOccs = false;
        if (pruneVarOccs) {
            Iterator it = varOccurrences.asMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                HashSet<Set<Set<Expr>>> varQuadCnfs = new HashSet<Set<Set<Expr>>>();
                for (VarOccurrence varOccurrence : (Collection)entry.getValue()) {
                    varQuadCnfs.add(varOccurrence.getQuadCnf());
                    if (varQuadCnfs.size() <= 1) continue;
                    break;
                }
                if (varQuadCnfs.size() != 1) continue;
                it.remove();
            }
        }
        QuadFilterPatternCanonical canonicalPattern = new QuadFilterPatternCanonical(quads, filterCnf);
        PatternSummary result = new PatternSummary(originalPattern, canonicalPattern, (IBiSetMultimap<Quad, Set<Set<Expr>>>)quadToCnf, (IBiSetMultimap<Var, VarOccurrence>)varOccurrences);
        for (Map.Entry entry : varOccurrences.asMap().entrySet()) {
        }
        return result;
    }

    public void lookup(Query query) {
        QuadFilterPattern qfp = ConceptMap.transform(query);
        this.lookup(qfp);
    }

    public static <K, V> Set<V> mapSet(Set<K> set, Map<K, V> map) {
        HashSet<V> result = new HashSet<V>();
        for (K item : set) {
            V v = map.get(item);
            result.add(v);
        }
        return result;
    }

    public CacheResult lookup(QuadFilterPattern queryQfp) {
        ArrayList<CacheHit> result = new ArrayList<CacheHit>();
        PatternSummary queryPs = this.summarize(queryQfp);
        Set quadCnfs = queryPs.getQuadToCnf().getInverse().keySet();
        HashSet<PatternSummary> rawCandsSet = new HashSet<PatternSummary>();
        int querySize = queryQfp.getQuads().size();
        for (Set quadCnf : quadCnfs) {
            Set cands = this.quadCnfToSummary.get((Object)quadCnf);
            for (PatternSummary cand : cands) {
                int candSize = cand.getCanonicalPattern().getQuads().size();
                if (candSize > querySize) continue;
                rawCandsSet.add(cand);
            }
        }
        ArrayList rawCands = new ArrayList(rawCandsSet);
        Collections.sort(rawCands, new Comparator<PatternSummary>(){

            @Override
            public int compare(PatternSummary a, PatternSummary b) {
                int x = a.getCanonicalPattern().getQuads().size();
                int y = b.getCanonicalPattern().getQuads().size();
                int r = x - y;
                return r;
            }
        });
        for (PatternSummary cand : rawCands) {
            Map<Set<Var>, Table> tmp = this.cacheData.get(cand);
            Set<Set<Var>> candVarCombos = tmp.keySet();
            Iterator<Map<Var, Var>> varMaps = this.computeVarMapQuadBased(queryPs, cand, candVarCombos);
            while (varMaps.hasNext()) {
                Map<Var, Var> varMap = varMaps.next();
                NodeTransformRenameMap rename = new NodeTransformRenameMap(varMap);
                QuadFilterPatternCanonical candRename = cand.getCanonicalPattern().applyNodeTransform((NodeTransform)rename);
                boolean isSubsumed = candRename.isSubsumedBy(queryPs.getCanonicalPattern());
                if (!isSubsumed) continue;
                Set<Var> candVars = candRename.getVarsMentioned();
                for (Map.Entry<Set<Var>, Table> entry : tmp.entrySet()) {
                    Set<Var> candVarCombo = entry.getKey();
                    Set<Var> queryCandVarCombo = ConceptMap.mapSet(candVarCombo, varMap);
                    Table table = entry.getValue();
                    Sets.SetView disallowedVars = Sets.difference(candVars, queryCandVarCombo);
                    QuadFilterPatternCanonical diffPattern = candRename.diff(queryPs.getCanonicalPattern());
                    Set<Var> testVars = diffPattern.getVarsMentioned();
                    Set<Var> cooccurs = Utils2.getCooccurrentVars(queryCandVarCombo, diffPattern.getQuads());
                    Sets.SetView intersection = Sets.intersection((Set)(disallowedVars = Sets.difference((Set)disallowedVars, cooccurs)), testVars);
                    if (!intersection.isEmpty()) continue;
                    table = Utils2.transform(table, (NodeTransform)rename);
                    CacheHit cacheHit = new CacheHit(candRename, diffPattern, table);
                    result.add(cacheHit);
                }
            }
        }
        System.out.println("CacheHits: " + result.size());
        QuadFilterPatternCanonical r = null;
        ArrayList<Table> tables = new ArrayList<Table>();
        for (CacheHit ch : result) {
            if (r == null) {
                r = ch.getDiffPattern();
                tables.add(ch.getTable());
                continue;
            }
            QuadFilterPatternCanonical diff = r.diff(ch.getDiffPattern());
            if (diff.equals(r)) continue;
            r = diff;
            tables.add(ch.getTable());
        }
        System.out.println("Tables: " + tables.size());
        CacheResult cr = r == null ? null : new CacheResult(r, tables);
        return cr;
    }

    public static Expr createExpr(ResultSet rs, Map<Var, Var> varMap) {
        if (rs.getResultVars().size() != 1) {
            throw new RuntimeException("Not supported yet");
        }
        String varName = (String)rs.getResultVars().iterator().next();
        Var var = Var.alloc((String)varName);
        Set<Node> nodes = ConceptMap.getResultSetCol(rs, var);
        ExprList exprs = ConceptMap.nodesToExprs(nodes);
        Var inVar = varMap.get(var);
        ExprVar ev = new ExprVar(inVar);
        E_OneOf result = new E_OneOf((Expr)ev, exprs);
        return result;
    }

    public static Set<Node> getResultSetCol(ResultSet rs, Var v) {
        HashSet<Node> result = new HashSet<Node>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node node = binding.get(v);
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    public static ExprList nodesToExprs(Iterable<Node> nodes) {
        ExprList result = new ExprList();
        for (Node node : nodes) {
            NodeValue expr = NodeValue.makeNode((Node)node);
            result.add((Expr)expr);
        }
        return result;
    }

    public static <K, V> Map<K, V> toMap(Map<K, ? extends Collection<V>> mm) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, Collection<V>> entry : mm.entrySet()) {
            K k = entry.getKey();
            Collection<V> vs = entry.getValue();
            if (vs.isEmpty()) continue;
            if (vs.size() > 1) {
                throw new RuntimeException("Ambigous mapping for " + k + ": " + vs);
            }
            V v = vs.iterator().next();
            result.put(k, v);
        }
        return result;
    }

    public static int getNumMatches(QuadGroup quadGroup) {
        int q;
        int c = quadGroup.getCandQuads().size();
        int result = c > (q = quadGroup.getQueryQuads().size()) ? 0 : (int)(CombinatoricsUtils.factorial((int)q) / CombinatoricsUtils.factorial((int)(q - c)));
        return result;
    }

    public static SetMultimap<Quad, Quad> quadJoinSummary(List<Quad> sub) {
        Node[] tmp = new Node[4];
        HashMultimap result = HashMultimap.create();
        for (int i = 0; i < sub.size(); ++i) {
            Quad a = sub.get(i);
            for (int j = i + 1; j < sub.size(); ++j) {
                Quad b = sub.get(j);
                for (int k = 0; k < 4; ++k) {
                    Node c;
                    Node nb;
                    Node na = QuadUtils.getNode((Quad)a, (int)k);
                    boolean isEqual = na.equals((Object)(nb = QuadUtils.getNode((Quad)b, (int)k)));
                    tmp[k] = c = isEqual ? NodeValue.TRUE.asNode() : NodeValue.FALSE.asNode();
                }
                Quad summary = QuadUtils.create((Node[])tmp);
                result.put((Object)summary, (Object)a);
                result.put((Object)summary, (Object)b);
            }
        }
        return result;
    }

    public Iterator<Map<Var, Var>> computeVarMapQuadBased(PatternSummary query, PatternSummary cand, Set<Set<Var>> candVarCombos) {
        IBiSetMultimap cnfToCandQuad = cand.getQuadToCnf().getInverse();
        IBiSetMultimap cnfToQueryQuad = query.getQuadToCnf().getInverse();
        ArrayList<QuadGroup> quadGroups = new ArrayList<QuadGroup>();
        for (Map.Entry entry : cnfToCandQuad.asMap().entrySet()) {
            Set cnf = (Set)entry.getKey();
            Collection candQuads = (Collection)entry.getValue();
            Set queryQuads = cnfToQueryQuad.get((Object)cnf);
            if (queryQuads.isEmpty()) {
                return Collections.emptySet().iterator();
            }
            QuadGroup quadGroup = new QuadGroup(candQuads, queryQuads);
            quadGroups.add(quadGroup);
        }
        Collections.sort(quadGroups, new Comparator<QuadGroup>(){

            @Override
            public int compare(QuadGroup a, QuadGroup b) {
                int i = ConceptMap.getNumMatches(a);
                int j = ConceptMap.getNumMatches(b);
                int r = j - i;
                return r;
            }
        });
        ArrayList<Iterable<Map<Var, Var>>> cartesian = new ArrayList<Iterable<Map<Var, Var>>>(quadGroups.size());
        Map<Var, Var> baseMapping = Collections.emptyMap();
        for (QuadGroup quadGroup : quadGroups) {
            Iterable<Map<Var, Var>> it = IterableVarMapQuadGroup.create(quadGroup, baseMapping);
            cartesian.add(it);
        }
        CartesianProduct cart = new CartesianProduct(cartesian);
        IteratorVarMapQuadGroups result = new IteratorVarMapQuadGroups(cart.iterator());
        return result;
    }

    public static <K, V> Map<K, V> mergeCompatible(Iterable<Map<K, V>> maps) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map<K, V> map : maps) {
            if (MapUtils.isPartiallyCompatible(map, result)) {
                result.putAll(map);
                continue;
            }
            result = null;
            break;
        }
        return result;
    }

    public Map<Var, Var> computeVarMap(PatternSummary query, PatternSummary cand, Set<Set<Var>> candVarCombos) {
        IBiSetMultimap candVos = cand.getVarOccurrences().getInverse();
        IBiSetMultimap queryVos = query.getVarOccurrences().getInverse();
        boolean abort = false;
        BiHashMultimap candToQuery = new BiHashMultimap();
        for (Map.Entry candEntry : candVos.asMap().entrySet()) {
            Set candVars = (Set)candEntry.getValue();
            VarOccurrence candVo = (VarOccurrence)candEntry.getKey();
            Set queryVars = queryVos.get((Object)candVo);
            for (Var candVar : candVars) {
                candToQuery.putAll((Object)candVar, (Collection)queryVars);
            }
        }
        ArrayList varOrder = new ArrayList(candToQuery.keySet());
        Collections.sort(varOrder, new Comparator<Var>((IBiSetMultimap)candToQuery){
            final /* synthetic */ IBiSetMultimap val$candToQuery;
            {
                this.val$candToQuery = iBiSetMultimap;
            }

            @Override
            public int compare(Var a, Var b) {
                int i = this.val$candToQuery.get((Object)a).size();
                int j = this.val$candToQuery.get((Object)b).size();
                int r = j - i;
                return r;
            }
        });
        Map<Var, Var> result = abort ? null : ConceptMap.toMap(candToQuery.asMap());
        return result;
    }

    public static void backtrackMeh(PatternSummary query, PatternSummary cand, Map<Var, Set<Var>> candToQuery, List<Var> varOrder, int index) {
        Var var = varOrder.get(index);
        Set<Var> queryVars = candToQuery.get(var);
        for (Var queryVar : queryVars) {
        }
    }

    public static Table createTable(ResultSet rs) {
        List<Var> vars = VarUtils.toList(rs.getResultVars());
        Table result = TableFactory.create(vars);
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            result.addBinding(binding);
        }
        return result;
    }

    public void index(Query query, ResultSet rs) {
        Table tmp;
        Table table = ConceptMap.createTable(rs);
        QuadFilterPattern qfp = ConceptMap.transform(query);
        PatternSummary ps = this.summarize(qfp);
        Set<Var> vars = VarUtils.toSet(rs.getResultVars());
        Map<Set<Var>, Table> map = this.cacheData.get(qfp);
        if (map == null) {
            map = new HashMap<Set<Var>, Table>();
            this.cacheData.put(ps, map);
        }
        if ((tmp = map.get(vars)) != null) {
            throw new RuntimeException("Already cached data for result set");
        }
        map.put(vars, table);
        Set quadCnfs = ps.getQuadToCnf().getInverse().keySet();
        for (Set quadCnf : quadCnfs) {
            this.quadCnfToSummary.put((Object)quadCnf, (Object)ps);
        }
    }

    public static Set<Var> getRefVars(Query query) {
        return null;
    }
}

