/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.google.common.base.Stopwatch;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.util.StreamUtils;
import org.aksw.jena_sparql_api.concept_cache.ConceptMap;
import org.aksw.jena_sparql_api.concept_cache.QueryExecutionFactoryConceptCache;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceBuilder;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ConceptCache {
    private ConceptMap conceptMap = new ConceptMap();
    private Map<Concept, List<Resource>> extension = new HashMap<Concept, List<Resource>>();
    private QueryExecutionFactory sparqlService;

    public ConceptCache(QueryExecutionFactory sparqlService) {
        this.sparqlService = sparqlService;
    }

    public static void applyCache() {
    }

    public void index(Query query, ResultSet rs) {
        this.conceptMap.index(query, rs);
    }

    public void index(Query query) {
        String varName = "a";
        Var v = Var.alloc((String)varName);
        List<String> varList = Arrays.asList(varName);
        ArrayList<BindingHashMap> bindings = new ArrayList<BindingHashMap>();
        BindingHashMap binding = new BindingHashMap();
        binding.add(v, RDF.type.asNode());
        bindings.add(binding);
        QueryIterPlainWrapper queryIter = new QueryIterPlainWrapper(bindings.iterator());
        ResultSet rs = ResultSetFactory.create((QueryIterator)queryIter, varList);
        rs = ResultSetFactory.copyResults((ResultSet)rs);
        this.conceptMap.index(query, rs);
    }

    public ResultSet execSelect(Query query) {
        this.conceptMap.lookup(query);
        return null;
    }

    public static void main(String[] args) throws IOException {
        Object sparqlService = SparqlServiceBuilder.http((String)"http://akswnc3.informatik.uni-leipzig.de:8860/sparql", (String[])new String[]{"http://dbpedia.org"}).withPagination(100000L).create();
        ConceptCache cache = new ConceptCache((QueryExecutionFactory)sparqlService);
        sparqlService = new QueryExecutionFactoryConceptCache((QueryExecutionFactory)sparqlService);
        QueryExecutionFactoryModel ss = new QueryExecutionFactoryModel();
        Query query = QueryFactory.create((String)"Select * { VALUES (?x) { ('foo') ('bar') } }");
        ResultSet rs = ss.createQueryExecution(query).execSelect();
        String str = ResultSetFormatter.asText((ResultSet)rs);
        System.out.println(str);
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        System.out.println(op);
        query = OpAsQuery.asQuery((Op)op);
        System.out.println(query);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource r = resolver.getResource("query-lorenz-1a.sparql");
        String queryString = StreamUtils.toString((InputStream)r.getInputStream());
        Query query2 = QueryFactory.create((String)queryString);
        op = Algebra.compile((Query)query2);
        op = Algebra.toQuadForm((Op)op);
        System.out.println(op);
        for (int i = 0; i < 1; ++i) {
            Stopwatch sw = Stopwatch.createStarted();
            long a = sw.elapsed(TimeUnit.MILLISECONDS);
            Resource r2 = resolver.getResource("query-lorenz-1a.sparql");
            String queryString2 = StreamUtils.toString((InputStream)r2.getInputStream());
            Query query3 = QueryFactory.create((String)queryString2);
            QueryExecution qe = sparqlService.createQueryExecution(query3);
            ResultSet rs2 = qe.execSelect();
            ResultSetFormatter.consume((ResultSet)rs2);
            long b = sw.elapsed(TimeUnit.MILLISECONDS);
            System.out.println("Time taken: " + (b - a));
            r2 = resolver.getResource("query-lorenz-1b.sparql");
            queryString2 = StreamUtils.toString((InputStream)r2.getInputStream());
            query3 = QueryFactory.create((String)queryString2);
            qe = sparqlService.createQueryExecution(query3);
            rs2 = qe.execSelect();
            ResultSetFormatter.consume((ResultSet)rs2);
            long c = sw.elapsed(TimeUnit.MILLISECONDS);
            System.out.println("Time taken: " + (c - b));
        }
    }
}

