/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.google.common.base.Stopwatch;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.util.StreamUtils;
import org.aksw.jena_sparql_api.compare.QueryExecutionFactoryCompare;
import org.aksw.jena_sparql_api.concept_cache.QueryExecutionFactoryConceptCache;
import org.aksw.jena_sparql_api.concept_cache.QueryRunner;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceBuilder;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class TestCases {
    public static void main(String[] args) throws Exception {
        Stopwatch sw;
        int i;
        QueryExecutionFactory rawService = SparqlServiceBuilder.http((String)"http://akswnc3.informatik.uni-leipzig.de:8860/sparql", (String[])new String[]{"http://dbpedia.org"}).withPagination(100000L).create();
        QueryExecutionFactoryConceptCache cachedService = new QueryExecutionFactoryConceptCache(rawService);
        boolean forceCompareFailures = false;
        if (forceCompareFailures) {
            rawService = SparqlServiceBuilder.http((String)"http://linkedgeodata.org/sparql", (String[])new String[]{"http://linkedgeodata.org"}).withPagination(100000L).create();
        }
        Object sparqlService = new QueryExecutionFactoryCompare(rawService, (QueryExecutionFactory)cachedService);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sparqlService = cachedService;
        QueryRunner runner = new QueryRunner((QueryExecutionFactory)sparqlService);
        for (i = 0; i < 1000; ++i) {
            sw = Stopwatch.createStarted();
            String varStr = "?hm_" + i;
            String qs = "Prefix o: <http://dbpedia.org/ontology/> Select Distinct ?s { ?s a o:Airport ; o:city <http://dbpedia.org/resource/Leipzig> }".replace("?s", varStr);
            System.out.println("qs = " + qs);
            runner.trySelect(qs);
            System.out.println("Time taken: " + sw.elapsed(TimeUnit.MILLISECONDS));
        }
        for (i = 0; i < 0; ++i) {
            sw = Stopwatch.createStarted();
            Resource r = resolver.getResource("query-lorenz-1a.sparql");
            String queryString = StreamUtils.toString((InputStream)r.getInputStream());
            Query query = QueryFactory.create((String)queryString);
            QueryExecution qe = sparqlService.createQueryExecution(query);
            ResultSet rs = qe.execSelect();
            ResultSetFormatter.consume((ResultSet)rs);
            long elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
            System.out.println("Time taken: " + elapsed);
        }
    }
}

