/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.aksw.jena_sparql_api.concept_cache.CacheHit;
import org.aksw.jena_sparql_api.concept_cache.ConceptMap;
import org.aksw.jena_sparql_api.concept_cache.OpUtils;
import org.aksw.jena_sparql_api.concept_cache.QueryExecutionConceptCache;
import org.aksw.jena_sparql_api.concept_cache.domain.QuadFilterPattern;
import org.aksw.jena_sparql_api.concept_cache.domain.QuadFilterPatternCanonical;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDecorator;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;

public class QueryExecutionFactoryConceptCache
extends QueryExecutionFactoryDecorator {
    private ConceptMap conceptMap = new ConceptMap();

    public QueryExecutionFactoryConceptCache(QueryExecutionFactory decoratee) {
        super(decoratee);
    }

    public QueryExecution createQueryExecution(String queryString) {
        Query query = QueryFactory.create((String)queryString);
        QueryExecution result = this.createQueryExecution(query);
        return result;
    }

    public QueryExecution createQueryExecution(Query query) {
        Object result;
        QuadFilterPattern qfp = ConceptMap.transform(query);
        List<Object> cacheHits = qfp == null ? Collections.emptyList() : this.conceptMap.lookup(qfp);
        System.out.println("CacheHits: " + cacheHits.size());
        boolean isPatternFree = false;
        if (!cacheHits.isEmpty()) {
            CacheHit cacheHit = (CacheHit)cacheHits.iterator().next();
            QuadFilterPatternCanonical qfpc = cacheHit.getPattern();
            Object op = qfpc.toOp();
            Table table = cacheHit.getTable();
            OpTable opTable = OpTable.create((Table)table);
            System.out.println("Table size: " + table.size());
            op = op instanceof OpNull ? opTable : OpJoin.create((Op)opTable, (Op)op);
            isPatternFree = OpUtils.isPatternFree(op);
            System.out.println("isPatternFree: " + isPatternFree);
            Query yay = OpAsQuery.asQuery((Op)op);
            yay.setQueryResultStar(false);
            yay.getProjectVars().clear();
            for (Var x : query.getProjectVars()) {
                yay.getProject().add(x);
            }
            query = yay;
        }
        System.out.println("Running query: " + query.toString().substring(0, Math.min(2000, query.toString().length())));
        boolean isIndexable = qfp != null;
        List vars = query.getProjectVars();
        if (isPatternFree) {
            QueryExecutionFactoryModel ss = new QueryExecutionFactoryModel();
            result = ss.createQueryExecution(query);
        } else {
            QueryExecution qe = this.decoratee.createQueryExecution(query);
            if (isIndexable && !vars.isEmpty()) {
                Set<Var> indexVars = Collections.singleton(vars.iterator().next());
                result = new QueryExecutionConceptCache(qe, this.conceptMap, query, indexVars);
            } else {
                result = qe;
            }
        }
        return result;
    }
}

