/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept_cache;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Set;
import org.aksw.jena_sparql_api.concept_cache.ConceptMap;
import org.aksw.jena_sparql_api.concept_cache.ResultSetUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionDecoratorBase;

public class QueryExecutionConceptCache
extends QueryExecutionDecoratorBase<QueryExecution> {
    private ConceptMap conceptMap;
    private Query query;
    private Set<Var> indexVars;

    public QueryExecutionConceptCache(QueryExecution decoratee, ConceptMap conceptMap, Query query, Set<Var> indexVars) {
        super(decoratee);
        this.conceptMap = conceptMap;
        this.query = query;
        this.indexVars = indexVars;
    }

    public ResultSet execSelect() {
        ResultSet rs = this.decoratee.execSelect();
        rs = ResultSetFactory.copyResults((ResultSet)rs);
        ResultSet cacheRs = ResultSetUtils.project(rs, this.indexVars, true);
        this.conceptMap.index(this.query, cacheRs);
        return rs;
    }
}

