/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.h2;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import javax.sql.DataSource;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontendImpl;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDao;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDaoPostgres;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDataSource;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.tools.RunScript;

public class CacheUtilsH2 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheFrontend createCacheFrontend(String dbName, boolean dbInMemory, long cacheTTL) {
        String dbType = "file";
        if (dbInMemory) {
            dbType = "mem:";
        }
        try {
            Class.forName("org.h2.Driver");
            JdbcDataSource dataSource = new JdbcDataSource();
            dataSource.setURL("jdbc:h2:" + dbType + ":" + dbName + ";DB_CLOSE_DELAY=-1");
            dataSource.setUser("sa");
            dataSource.setPassword("sa");
            String schemaResourceName = "/org/aksw/jena_sparql_api/cache/cache-schema-pgsql.sql";
            InputStream in = CacheBackendDao.class.getResourceAsStream(schemaResourceName);
            if (in == null) {
                throw new RuntimeException("Failed to load resource: " + schemaResourceName);
            }
            InputStreamReader reader = new InputStreamReader(in);
            Connection conn = dataSource.getConnection();
            try {
                RunScript.execute((Connection)conn, (Reader)reader);
            }
            finally {
                conn.close();
            }
            CacheBackendDaoPostgres dao = new CacheBackendDaoPostgres(cacheTTL);
            CacheBackendDataSource cacheBackend = new CacheBackendDataSource((DataSource)dataSource, (CacheBackendDao)dao);
            return new CacheFrontendImpl((CacheBackend)cacheBackend);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create H2 CacheFrontend", e);
        }
    }

    public static QueryExecutionFactory createQueryExecutionFactory(QueryExecutionFactory decoratee, String dbName, boolean dbInMemory, long cacheTTL) {
        CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend(dbName, dbInMemory, cacheTTL);
        return new QueryExecutionFactoryCacheEx(decoratee, cacheFrontend);
    }
}

