/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch.processor;

import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import org.aksw.jena_sparql_api.batch.processor.UpdateService;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.ConceptUtils;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.utils.ElementUtils;

public class UpdateServiceSparql
implements UpdateService {
    private UpdateRequest updateRequest;
    private Var conceptVar;
    private UpdateExecutionFactory uef;

    @Override
    public UpdateProcessor prepare(Concept filter) {
        UpdateRequest modifiedRequest = UpdateServiceSparql.filterUpdateRequest(this.updateRequest, this.conceptVar, filter);
        UpdateProcessor result = this.uef.createUpdateProcessor(modifiedRequest);
        return result;
    }

    public static UpdateRequest filterUpdateRequest(UpdateRequest updateRequest, Var updateVar, Concept concept) {
        UpdateRequest result = new UpdateRequest();
        for (Update update : updateRequest) {
            Update tmp = UpdateServiceSparql.filterUpdate(update, updateVar, concept);
            result.add(tmp);
        }
        return result;
    }

    public static Update filterUpdate(Update update, Var updateVar, Concept concept) {
        Update result;
        if (concept == null || concept.isSubjectConcept()) {
            result = update;
        } else {
            Concept renamed = ConceptUtils.renameVar((Concept)concept, (Var)updateVar);
            Element renamedElement = renamed.getElement();
            if (update instanceof UpdateDeleteWhere) {
                throw new RuntimeException("Sorry, not implemented yet");
            }
            if (update instanceof UpdateModify) {
                UpdateModify updateModify = (UpdateModify)update;
                Element e = updateModify.getWherePattern();
                Element replacementElement = ElementUtils.mergeElements((Element)e, (Element)renamedElement);
                UpdateModify tmp = UpdateServiceSparql.cloneUpdateModify(updateModify);
                tmp.setElement(replacementElement);
                result = tmp;
            } else {
                throw new RuntimeException("Sorry, not implemented yet");
            }
        }
        return result;
    }

    public static UpdateModify cloneUpdateModify(UpdateModify update) {
        UpdateModify result = new UpdateModify();
        result.getUsing().addAll(update.getUsing());
        result.setWithIRI(update.getWithIRI());
        result.setElement(update.getWherePattern());
        for (Quad quad : update.getInsertQuads()) {
            result.getInsertAcc().addQuad(quad);
        }
        for (Quad quad : update.getDeleteQuads()) {
            result.getDeleteAcc().addQuad(quad);
        }
        return result;
    }
}

