/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.hp.hpl.jena.query.Query;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionUtils;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class TaskletSparqlCountData
extends StepExecutionListenerSupport
implements Tasklet,
InitializingBean {
    public static final String KEY = TaskletSparqlCountData.class.getSimpleName() + ".count";
    private Query query;
    private QueryExecutionFactory qef;

    public TaskletSparqlCountData(Query query, QueryExecutionFactory qef) {
        this.query = query;
        this.qef = qef;
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        long count = QueryExecutionUtils.countQuery((Query)this.query, (QueryExecutionFactory)this.qef);
        chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().put(KEY, (Object)count);
        return RepeatStatus.FINISHED;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.query);
        Assert.notNull((Object)this.qef);
    }
}

