/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.context.ApplicationContext;

public class SparqlBatchUtils {
    public static void cleanUp(ApplicationContext context) {
        JobExplorer jobExplorer = (JobExplorer)context.getBean(JobExplorer.class);
        JobRepository jobRepository = (JobRepository)context.getBean(JobRepository.class);
        Date endTime = new Date();
        List jobNames = jobExplorer.getJobNames();
        for (String jobName : jobNames) {
            List jobInstances = jobExplorer.getJobInstances(jobName, 0, 1000000);
            for (JobInstance jobInstance : jobInstances) {
                List jobExecutions = jobExplorer.getJobExecutions(jobInstance);
                for (JobExecution jobExecution : jobExecutions) {
                    Collection stepExecutions = jobExecution.getStepExecutions();
                    for (StepExecution stepExecution : stepExecutions) {
                        BatchStatus stepStatus = stepExecution.getStatus();
                        if (!stepStatus.equals((Object)BatchStatus.STARTED)) continue;
                        stepExecution.setStatus(BatchStatus.STOPPED);
                        stepExecution.setEndTime(endTime);
                        jobRepository.update(stepExecution);
                    }
                    BatchStatus jobStatus = jobExecution.getStatus();
                    if (!jobStatus.equals((Object)BatchStatus.STARTED)) continue;
                    jobExecution.setStatus(BatchStatus.STOPPED);
                    jobExecution.setEndTime(endTime);
                    jobRepository.update(jobExecution);
                }
            }
        }
    }
}

