/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Map;
import org.aksw.jena_sparql_api.batch.ConfigBatchJobDynamic;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

public class BatchWorkflowManager {
    private JobExplorer jobExplorer;
    private JobRepository jobRepository;
    private JobLauncher jobLauncher;
    private Job job;

    public void processWorkflow(String workflow) {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        gson.fromJson(workflow, type);
    }

    public BatchWorkflowManager(JobExplorer jobExplorer, JobRepository jobRepository, JobLauncher jobLauncher, Job job) {
        this.jobExplorer = jobExplorer;
        this.jobRepository = jobRepository;
        this.jobLauncher = jobLauncher;
        this.job = job;
    }

    public JobExecution launchWorkflowJob(String workflowDesc) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        BatchStatus status;
        JobParameters jobParameters = new JobParametersBuilder().addString("serviceUri", workflowDesc, true).toJobParameters();
        JobExecution result = this.jobRepository.getLastJobExecution(this.job.getName(), jobParameters);
        BatchStatus batchStatus = status = result == null ? null : result.getStatus();
        if (status == null || !status.isRunning() && !status.equals((Object)BatchStatus.COMPLETED)) {
            result = this.jobLauncher.run(this.job, jobParameters);
        }
        return result;
    }

    public static BatchWorkflowManager createTestInstance() {
        EmbeddedDatabaseBuilder edb = new EmbeddedDatabaseBuilder();
        EmbeddedDatabase ed = edb.setType(EmbeddedDatabaseType.H2).addScript("classpath:org/springframework/batch/core/schema-drop-h2.sql").addScript("classpath:org/springframework/batch/core/schema-h2.sql").build();
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        beanFactory.registerSingleton(ed.getClass().getCanonicalName(), (Object)ed);
        context.register(new Class[]{ConfigBatchJobDynamic.class});
        context.refresh();
        JobExplorer jobExplorer = (JobExplorer)context.getBean(JobExplorer.class);
        JobRepository jobRepository = (JobRepository)context.getBean(JobRepository.class);
        JobLauncher jobLauncher = (JobLauncher)context.getBean(JobLauncher.class);
        Job job = (Job)context.getBean(Job.class);
        BatchWorkflowManager result = new BatchWorkflowManager(jobExplorer, jobRepository, jobLauncher, job);
        return result;
    }
}

