/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.Collection;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ResultSetXmlUtils {
    public static String toXmlStringBinding(Binding binding, Collection<String> varNames) {
        String result = "<result>";
        for (String varName : varNames) {
            Node node = binding.get(Var.alloc((String)varName));
            result = result + ResultSetXmlUtils.toXmlStringBindingItem(varName, node);
        }
        result = result + "</result>";
        return result;
    }

    public static String toXmlStringBindingItem(String varName, Node node) {
        String nodeStr = ResultSetXmlUtils.toXmlStringNode(node);
        String result = nodeStr == null ? "" : "<binding name=\"" + varName + "\">" + nodeStr + "</binding>";
        return result;
    }

    public static String toXmlStringNode(Node node) {
        String result;
        if (node == null) {
            result = null;
        } else if (node.isBlank()) {
            result = ResultSetXmlUtils.toXmlStringBlank(node);
        } else if (node.isURI()) {
            result = ResultSetXmlUtils.toXmlStringUri(node);
        } else if (node.isLiteral()) {
            result = ResultSetXmlUtils.toXmlStringLiteral(node);
        } else {
            throw new RuntimeException("Unknow node type: " + node);
        }
        return result;
    }

    public static String toXmlStringLiteral(Node node) {
        String datatype = node.getLiteralDatatypeURI();
        String lang = node.getLiteralLanguage();
        String result = "<literal";
        if (!StringUtils.isEmpty((CharSequence)lang)) {
            result = result + " xml:lang=\"" + lang + "\"";
        }
        if (!StringUtils.isEmpty((CharSequence)datatype)) {
            result = result + " datatype=\"" + datatype + "\"";
        }
        result = result + ">" + StringEscapeUtils.escapeXml((String)node.getLiteralLexicalForm()) + "</literal>";
        return result;
    }

    public static String toXmlStringBlank(Node node) {
        String label = node.getBlankNodeId().getLabelString();
        String result = "<bnode>" + label + "</bnode>";
        return result;
    }

    public static String toXmlStringUri(Node node) {
        String result = "<uri>" + StringEscapeUtils.escapeXml((String)node.getURI()) + "</uri>";
        return result;
    }
}

