/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.google.common.base.Joiner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.TreeSet;
import org.aksw.jena_sparql_api.batch.SparqlExportJobConfig;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SparqlExportManager {
    private JobExplorer jobExplorer;
    private JobRepository jobRepository;
    private JobLauncher jobLauncher;
    private Job job;

    public SparqlExportManager(JobExplorer jobExplorer, JobRepository jobRepository, JobLauncher jobLauncher, Job job) {
        this.jobExplorer = jobExplorer;
        this.jobRepository = jobRepository;
        this.jobLauncher = jobLauncher;
        this.job = job;
    }

    public JobExecution launchSparqlExport(String serviceUri, Collection<String> defaultGraphUris, String queryString, String targetResource) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        BatchStatus status;
        TreeSet<String> tmp = new TreeSet<String>(defaultGraphUris);
        String dgu = Joiner.on((char)' ').join(tmp);
        JobParameters jobParameters = new JobParametersBuilder().addString("serviceUri", serviceUri, true).addString("defaultGraphUris", dgu, true).addString("queryString", queryString, true).addString("targetResource", targetResource, true).toJobParameters();
        JobExecution result = this.jobRepository.getLastJobExecution(this.job.getName(), jobParameters);
        BatchStatus batchStatus = status = result == null ? null : result.getStatus();
        if (status != null && (status.isRunning() || status.equals((Object)BatchStatus.COMPLETED))) {
            return result;
        }
        result = this.jobLauncher.run(this.job, jobParameters);
        return result;
    }

    public InputStream getTargetInputStream(long jobExecutionId) throws FileNotFoundException {
        JobExecution jobExecution = this.jobExplorer.getJobExecution(Long.valueOf(jobExecutionId));
        JobParameters jobParameters = jobExecution.getJobParameters();
        String targetResource = jobParameters.getString("targetResource");
        FileInputStream result = new FileInputStream(targetResource);
        return result;
    }

    public static SparqlExportManager createTestInstance() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{SparqlExportJobConfig.class});
        JobExplorer jobExplorer = (JobExplorer)context.getBean(JobExplorer.class);
        JobRepository jobRepository = (JobRepository)context.getBean(JobRepository.class);
        JobLauncher jobLauncher = (JobLauncher)context.getBean(JobLauncher.class);
        Job job = (Job)context.getBean(Job.class);
        SparqlExportManager result = new SparqlExportManager(jobExplorer, jobRepository, jobLauncher, job);
        return result;
    }
}

