/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.batch.SparqlExportJobConfig;
import org.aksw.jena_sparql_api.batch.SparqlExportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class MainSparqlExportJobLauncher {
    private static final Logger logger = LoggerFactory.getLogger(MainSparqlExportJobLauncher.class);

    public static void main(String[] args) throws Exception {
        MainSparqlExportJobLauncher.cleanUp();
        System.out.println("Test");
        String fileName = "/tmp/people8.txt";
        String queryString = "Select * { ?s a <http://schema.org/Airport> . }";
        SparqlExportManager sparqlExportManager = SparqlExportManager.createTestInstance();
        JobExecution je = sparqlExportManager.launchSparqlExport("http://localhost/data/dbpedia/3.9/sparql", Arrays.asList("http://dbpedia.org/3.9/"), queryString, fileName);
        if (je.getStatus().equals((Object)BatchStatus.COMPLETED)) {
            ResultSet rs = ResultSetFactory.fromXML((InputStream)new FileInputStream(fileName));
            while (rs.hasNext()) {
                System.out.println(rs.nextBinding());
            }
        }
        block1: while (true) {
            Collection stepExecutions = je.getStepExecutions();
            Iterator i$ = stepExecutions.iterator();
            while (true) {
                if (!i$.hasNext()) continue block1;
                StepExecution stepExecution = (StepExecution)i$.next();
                ExecutionContext sec = stepExecution.getExecutionContext();
                System.out.println("CONTEXT");
                System.out.println(sec.entrySet());
                Thread.sleep(5000L);
            }
            break;
        }
    }

    public static void cleanUp() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{SparqlExportJobConfig.class});
        JobExplorer jobExplorer = (JobExplorer)context.getBean(JobExplorer.class);
        JobRepository jobRepository = (JobRepository)context.getBean(JobRepository.class);
        JobLauncher jobLauncher = (JobLauncher)context.getBean(JobLauncher.class);
        Date endTime = new Date();
        List jobNames = jobExplorer.getJobNames();
        for (String jobName : jobNames) {
            List jobInstances = jobExplorer.getJobInstances(jobName, 0, 1000000);
            for (JobInstance jobInstance : jobInstances) {
                List jobExecutions = jobExplorer.getJobExecutions(jobInstance);
                for (JobExecution jobExecution : jobExecutions) {
                    Collection stepExecutions = jobExecution.getStepExecutions();
                    for (StepExecution stepExecution : stepExecutions) {
                        BatchStatus stepStatus = stepExecution.getStatus();
                        if (!stepStatus.equals((Object)BatchStatus.STARTED)) continue;
                        stepExecution.setStatus(BatchStatus.STOPPED);
                        stepExecution.setEndTime(endTime);
                        jobRepository.update(stepExecution);
                    }
                    BatchStatus jobStatus = jobExecution.getStatus();
                    if (!jobStatus.equals((Object)BatchStatus.STARTED)) continue;
                    jobExecution.setStatus(BatchStatus.STOPPED);
                    jobExecution.setEndTime(endTime);
                    jobRepository.update(jobExecution);
                }
            }
        }
    }
}

