/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.batch.BindingMapper;
import org.aksw.jena_sparql_api.batch.PagingQuery;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.pagination.extra.PaginationQueryIterator;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public class SparqlPagingItemReader<T>
extends AbstractPaginatedDataItemReader<T> {
    private QueryExecutionFactory sparqlService;
    private BindingMapper<T> bindingMapper;
    private volatile Query query = null;
    private volatile Iterator<Query> itQuery = null;

    public SparqlPagingItemReader() {
        this.setName(((Object)((Object)this)).getClass().getName());
    }

    public void setSparqlService(QueryExecutionFactory sparqlService) {
        this.sparqlService = sparqlService;
    }

    public QueryExecutionFactory getSparqlService() {
        return this.sparqlService;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public String getQueryString() {
        return "" + this.query;
    }

    public void setBindingMapper(BindingMapper<T> bindingMapper) {
        this.bindingMapper = bindingMapper;
    }

    public BindingMapper<?> getBindingMapper() {
        return this.bindingMapper;
    }

    protected Iterator<T> doPageRead() {
        PagingQuery pagingQuery = new PagingQuery(this.pageSize, this.query);
        PaginationQueryIterator itQuery = pagingQuery.createQueryIterator(this.page * this.pageSize);
        Query query = (Query)itQuery.next();
        if (query == null) {
            List tmp = Collections.emptyList();
            return tmp.iterator();
        }
        QueryExecution qe = this.sparqlService.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        ArrayList<T> items = new ArrayList<T>();
        long rowId = 0L;
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            T item = this.bindingMapper.map(binding, ++rowId);
            items.add(item);
        }
        return items.iterator();
    }
}

