/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.batch;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.aksw.jena_sparql_api.batch.BindingMapperPassThrough;
import org.aksw.jena_sparql_api.batch.DataCountTasklet;
import org.aksw.jena_sparql_api.batch.LineAggregatorBindingToXml;
import org.aksw.jena_sparql_api.batch.SparqlPagingItemReader;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobOperator;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.file.FlatFileFooterCallback;
import org.springframework.batch.item.file.FlatFileHeaderCallback;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.support.PassThroughItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableBatchProcessing
public class SparqlExportJobConfig {
    public static final String JOBPARAM_SERVICE_URI = "serviceUri";
    public static final String JOBPARAM_DEFAULT_GRAPH_URIS = "defaultGraphUris";
    public static final String JOBPARAM_QUERY_STRING = "queryString";
    public static final String JOBPARAM_TARGET_RESOURCE = "targetResource";
    @Autowired
    private JobBuilderFactory jobBuilders;
    @Autowired
    private StepBuilderFactory stepBuilders;
    @Autowired
    private SparqlServiceFactory sparqlServiceFactory;
    private static final int chunkSize = 1000;

    @Bean
    @Autowired
    public JobExplorerFactoryBean jobExplorer(DataSource dataSource) {
        JobExplorerFactoryBean result = new JobExplorerFactoryBean();
        result.setDataSource(dataSource);
        return result;
    }

    @Bean
    @Autowired
    public JobOperator jobOperator(JobExplorer jobExplorer, JobLauncher jobLauncher, JobRepository jobRepository, ListableJobLocator jobRegistry) {
        SimpleJobOperator jobOperator = new SimpleJobOperator();
        jobOperator.setJobExplorer(jobExplorer);
        jobOperator.setJobLauncher(jobLauncher);
        jobOperator.setJobRepository(jobRepository);
        jobOperator.setJobRegistry(jobRegistry);
        return jobOperator;
    }

    @Bean
    public TaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(5);
        taskExecutor.setMaxPoolSize(5);
        return taskExecutor;
    }

    @Bean
    @Autowired
    public JobLauncher jobLauncher(JobRepository jobRepository) {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(jobRepository);
        jobLauncher.setTaskExecutor(this.taskExecutor());
        return jobLauncher;
    }

    @Bean
    public Job sparqlExportJob() {
        JobBuilder jobBuilder = this.jobBuilders.get("sparqlExportJob");
        SimpleJobBuilder jb = jobBuilder.start(this.dataCountStep(null, null));
        jb = jb.next(this.dataFetchStep());
        Job job = jb.build();
        return job;
    }

    @Bean
    @Autowired
    public Step dataCountStep(Query query, QueryExecutionFactory sparqlService) {
        DataCountTasklet tasklet = new DataCountTasklet(query, sparqlService);
        return this.stepBuilders.get("dataCountStep").tasklet((Tasklet)tasklet).build();
    }

    @Bean
    public Step dataFetchStep() {
        return this.stepBuilders.get("dataFetchStep").chunk(1000).reader(this.reader(null, null, null)).processor(this.processor()).writer(this.writer(null, null)).build();
    }

    @Bean
    @StepScope
    public Query query(@Value(value="#{jobParameters[queryString]}") String queryString) {
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL_11);
        return query;
    }

    @Bean
    @StepScope
    public QueryExecutionFactory sparqlService(@Value(value="#{jobParameters[serviceUri]}") String serviceUri, @Value(value="#{jobParameters[defaultGraphUris]}") String defaultGraphUris) {
        String[] tmp = defaultGraphUris.split(" ");
        List<String> dgus = Arrays.asList(tmp);
        QueryExecutionFactory sparqlService = this.sparqlServiceFactory.createSparqlService(serviceUri, dgus);
        return sparqlService;
    }

    @Bean
    @StepScope
    @Autowired
    public SparqlPagingItemReader<Binding> reader(Query query, QueryExecutionFactory sparqlService, @Value(value="#{jobParameters[queryString]}") String queryString) {
        SparqlPagingItemReader<Binding> itemReader = new SparqlPagingItemReader<Binding>();
        itemReader.setSparqlService(sparqlService);
        itemReader.setBindingMapper(new BindingMapperPassThrough());
        itemReader.setPageSize(1000);
        itemReader.setSaveState(true);
        itemReader.setQuery(query);
        return itemReader;
    }

    @Bean
    @StepScope
    @Autowired
    public ResourceAwareItemWriterItemStream<Binding> writer(final Query query, @Value(value="#{jobParameters[targetResource]}") String targetResource) {
        FlatFileItemWriter itemWriter = new FlatFileItemWriter();
        itemWriter.setResource((Resource)new FileSystemResource(targetResource));
        itemWriter.setLineAggregator(this.lineAggregator(null));
        itemWriter.setEncoding("UTF-8");
        itemWriter.setSaveState(true);
        itemWriter.setHeaderCallback(new FlatFileHeaderCallback(){

            public void writeHeader(Writer writer) throws IOException {
                PrintWriter pw = new PrintWriter(writer);
                pw.println("<?xml version=\"1.0\"?>");
                pw.println("<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2.xsd\">");
                pw.println(" <head>");
                List varNames = query.getResultVars();
                for (String varName : varNames) {
                    pw.println("  <variable name=\"" + varName + "\" />");
                }
                pw.println(" </head>");
                pw.print(" <results distinct=\"" + query.isDistinct() + "\" " + "ordered=\"" + !CollectionUtils.isEmpty((Collection)query.getOrderBy()) + "\">");
                pw.flush();
            }
        });
        itemWriter.setFooterCallback(new FlatFileFooterCallback(){

            public void writeFooter(Writer writer) throws IOException {
                PrintWriter pw = new PrintWriter(writer);
                pw.println(" </results>");
                pw.println("</sparql>");
                pw.flush();
            }
        });
        return itemWriter;
    }

    @Bean
    @StepScope
    @Autowired
    public LineAggregator<Binding> lineAggregator(Query query) {
        List varNames = query.getResultVars();
        LineAggregatorBindingToXml result = new LineAggregatorBindingToXml(varNames);
        return result;
    }

    @Bean
    @StepScope
    @Autowired
    public ItemProcessor<Binding, Binding> processor() {
        return new PassThroughItemProcessor();
    }
}

