/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jdbc_utils.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.jdbc_utils.core.Column;
import org.aksw.jdbc_utils.core.ColumnsReference;
import org.aksw.jdbc_utils.core.DatabaseObject;
import org.aksw.jdbc_utils.core.ForeignKey;
import org.aksw.jdbc_utils.core.Index;
import org.aksw.jdbc_utils.core.PrimaryKey;
import org.aksw.jdbc_utils.core.Relation;

public class JdbcUtils {
    public static Multimap<String, ForeignKey> fetchForeignKeys(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Multimap<String, ForeignKey> result = JdbcUtils.fetchForeignKeys(meta, catalog);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Multimap<String, ForeignKey> fetchForeignKeys(DatabaseMetaData meta, String catalog) throws SQLException {
        HashMultimap result = HashMultimap.create();
        ResultSet rs = meta.getExportedKeys(catalog, null, null);
        try {
            HashMap<String, ForeignKey> fkNameMap = new HashMap<String, ForeignKey>();
            while (rs.next()) {
                String fkName = rs.getString("FK_NAME");
                String fkTableName = rs.getString("FKTABLE_NAME");
                String fkColumnName = rs.getString("FKCOLUMN_NAME");
                String pkTableName = rs.getString("PKTABLE_NAME");
                String pkColumnName = rs.getString("PKCOLUMN_NAME");
                ForeignKey current = (ForeignKey)fkNameMap.get(fkName);
                if (current == null) {
                    current = new ForeignKey(fkName, new ColumnsReference(fkTableName, new String[0]), new ColumnsReference(pkTableName, new String[0]));
                    fkNameMap.put(fkName, current);
                }
                current.getSource().getColumnNames().add(fkColumnName);
                current.getTarget().getColumnNames().add(pkColumnName);
            }
            for (ForeignKey fk : fkNameMap.values()) {
                result.put((Object)fk.getSource().getTableName(), (Object)fk);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    public static Map<String, PrimaryKey> fetchPrimaryKeys(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Map<String, PrimaryKey> result = JdbcUtils.fetchPrimaryKeys(meta, catalog);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PrimaryKey> fetchPrimaryKeys(DatabaseMetaData meta, String catalog) throws SQLException {
        HashMap<String, PrimaryKey> result = new HashMap<String, PrimaryKey>();
        ResultSet rs = meta.getPrimaryKeys(catalog, null, null);
        try {
            PrimaryKey current = null;
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                String pkName = rs.getString("PK_NAME");
                if (current == null || !tableName.equals(current.getSource().getTableName())) {
                    current = new PrimaryKey(pkName, new ColumnsReference(tableName, new String[0]));
                    result.put(tableName, current);
                }
                current.getSource().getColumnNames().add(columnName);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    public static Set<String> fetchRelationNames(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Set<String> result = JdbcUtils.fetchRelationNames(meta, catalog);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> fetchRelationNames(DatabaseMetaData meta, String catalog) throws SQLException {
        String[] types = new String[]{"TABLE", "VIEW"};
        ResultSet rs = meta.getTables(catalog, null, null, types);
        TreeSet<String> result = new TreeSet<String>();
        try {
            while (rs.next()) {
                result.add(rs.getString("TABLE_NAME"));
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    public static Map<String, Relation> fetchColumns(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Map<String, Relation> result = JdbcUtils.fetchColumns(meta, catalog, null, null);
        return result;
    }

    public static Map<String, Relation> fetchColumns(Connection conn, String schema, String table) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Map<String, Relation> result = JdbcUtils.fetchColumns(meta, catalog, schema, table);
        return result;
    }

    public static Map<String, Relation> fetchColumns(DatabaseMetaData meta, String catalog) throws SQLException {
        Map<String, Relation> result = JdbcUtils.fetchColumns(meta, catalog, null, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Relation> fetchColumns(DatabaseMetaData meta, String catalog, String schema, String table) throws SQLException {
        HashMap<String, Relation> result = new HashMap<String, Relation>();
        ResultSet rs = meta.getColumns(catalog, schema, table, null);
        try {
            DatabaseObject current = null;
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                String typeName = rs.getString("TYPE_NAME");
                String rawIsNullable = rs.getString("IS_NULLABLE");
                int ordinalPosition = rs.getInt("ORDINAL_POSITION");
                Boolean isNullable = null;
                if ("YES".equalsIgnoreCase(rawIsNullable)) {
                    isNullable = true;
                } else if ("NO".equalsIgnoreCase(rawIsNullable)) {
                    isNullable = false;
                }
                if (current == null || !tableName.equals(current.getName())) {
                    current = new Relation(tableName);
                    result.put(tableName, (Relation)current);
                }
                Column column = new Column(ordinalPosition, columnName, typeName, isNullable);
                ((Relation)current).getColumns().put(columnName, column);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    public static Multimap<String, Index> fetchIndexes(DatabaseMetaData meta, String catalog, String schemaName, String tableName, boolean unique) throws SQLException {
        ArrayListMultimap result = ArrayListMultimap.create();
        ResultSet rs = meta.getIndexInfo(catalog, schemaName, tableName, unique, false);
        DatabaseObject current = null;
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String table = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            boolean isNonUnique = rs.getBoolean("NON_UNIQUE");
            if (indexName == null) continue;
            if (current == null || !indexName.equals(current.getName())) {
                current = new Index(tableName, table, !isNonUnique);
                result.put((Object)tableName, (Object)current);
            }
            ((Index)current).getColumns().getColumnNames().add(columnName);
        }
        return result;
    }
}

