/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jdbc_utils.core;

import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.jdbc_utils.core.ColumnsReference;
import org.aksw.jdbc_utils.core.PrimaryKey;
import org.aksw.jdbc_utils.core.Schema;
import org.aksw.jdbc_utils.core.SqlUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class Inserter {
    private ColumnsReference target;
    private Schema schema;
    private List<Object> data = new ArrayList<Object>();

    public Inserter(ColumnsReference target, Schema schema) {
        this.target = target;
        this.schema = schema;
    }

    public void add(Object ... cells) {
        if (cells.length != this.target.getColumnNames().size()) {
            throw new RuntimeException("Provided cells (" + cells.length + ") does not match number of columns (" + this.target.getColumnNames().size() + "), Columns:" + this.target.getColumnNames() + " Data: " + cells);
        }
        for (Object cell : cells) {
            this.data.add(cell);
        }
    }

    public static String escapeSql(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof Number) {
            return "" + o;
        }
        return "'" + StringEscapeUtils.escapeSql((String)("" + o)) + "'";
    }

    public String composeValues(List<Object> cells, int columnWidth, int[] idMap, List<Integer> indexes) {
        int numRows = indexes == null ? this.data.size() / columnWidth : indexes.size();
        String idList = "";
        for (int i = 0; i < numRows; ++i) {
            int rowId;
            int n = rowId = indexes == null ? i : indexes.get(i);
            if (rowId != 0) {
                idList = idList + ", ";
            }
            if (columnWidth > 1) {
                idList = idList + "(";
            }
            for (int j = 0; j < idMap.length; ++j) {
                int index = rowId * columnWidth + idMap[j];
                Object cell = this.data.get(index);
                if (j != 0) {
                    idList = idList + ", ";
                }
                idList = idList + Inserter.escapeSql("" + cell);
            }
            if (columnWidth <= 1) continue;
            idList = idList + ")";
        }
        return idList;
    }

    public List<Integer> getBlacklistedRows(List<Object> cells, int columnWidth, int[] idMap, Set<Object> ids) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int numRows = this.data.size() / columnWidth;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < idMap.length; ++j) {
                int index = i * columnWidth + idMap[j];
                Object cell = this.data.get(index);
                if (!ids.contains(cell)) continue;
                result.add(i);
            }
        }
        return result;
    }

    public String composeInsertPart(List<Object> cells, int columnWidth, Set<Integer> blacklistedRows) {
        int numRows = this.data.size() / columnWidth;
        String idList = "";
        for (int i = 0; i < numRows; ++i) {
            if (blacklistedRows.contains(i)) continue;
            if (!idList.isEmpty()) {
                idList = idList + ", ";
            }
            idList = idList + "(";
            for (int j = 0; j < columnWidth; ++j) {
                int index = i * columnWidth + j;
                Object cell = this.data.get(index);
                if (j != 0) {
                    idList = idList + ", ";
                }
                idList = idList + Inserter.escapeSql("" + cell);
            }
            idList = idList + ")";
        }
        return idList;
    }

    public void flush(Connection conn) throws SQLException {
        Set<Integer> skipIndexes;
        String valueList;
        PrimaryKey targetPk = this.schema.getPrimaryKeys().get(this.target.getTableName());
        int columnWidth = this.target.getColumnNames().size();
        HashSet<Object> duplicateIds = new HashSet<Object>();
        String targetColumnsStr = "\"" + Joiner.on((String)"\", \"").join(this.target.getColumnNames()) + "\"";
        if (targetPk != null) {
            List<Integer> blacklistedRows;
            List<String> idColumns = targetPk.getSource().getColumnNames();
            int d = idColumns.size();
            int[] idMap = new int[d];
            for (int i = 0; i < d; ++i) {
                String idColumn = idColumns.get(i);
                int j = this.target.getColumnNames().indexOf(idColumn);
                if (j < 0) {
                    throw new RuntimeException("Need all primary key columns: Inserted Columns " + this.target.getColumnNames() + ", Primary Key: " + targetPk.getSource().getColumnNames());
                }
                idMap[i] = j;
            }
            String idColumnsStr = "\"" + Joiner.on((String)"\", \"").join(idColumns) + "\"";
            String inColumnsStr = columnWidth > 1 ? "(" + idColumnsStr + ")" : idColumnsStr;
            String idList = this.composeValues(this.data, columnWidth, idMap, null);
            if (!idList.isEmpty()) {
                String query = "SELECT " + idColumnsStr + " FROM \"" + this.target.getTableName() + "\" WHERE " + inColumnsStr + " IN (" + idList + ")";
                System.out.println("Dup check: " + query);
                List<Object> dupList = SqlUtils.executeList(conn, query, Object.class, new Object[0]);
                duplicateIds.addAll(dupList);
                System.out.println("Dups are: " + duplicateIds);
            }
            if ((blacklistedRows = this.getBlacklistedRows(this.data, columnWidth, idMap, duplicateIds)).size() > 0) {
                String deleteIdList = this.composeValues(this.data, columnWidth, idMap, blacklistedRows);
                String query = "DELETE FROM \"" + this.target.getTableName() + "\" WHERE " + inColumnsStr + " IN (" + idList + ")";
                System.out.println("Delete query: " + query);
                SqlUtils.execute(conn, query, Void.class, new Object[0]);
            }
        }
        if (!(valueList = this.composeInsertPart(this.data, columnWidth, skipIndexes = Collections.emptySet())).isEmpty()) {
            String query = "INSERT INTO \"" + this.target.getTableName() + "\" (" + targetColumnsStr + ") VALUES " + valueList;
            System.out.println("Insert: " + query);
            SqlUtils.execute(conn, query, Void.class, new Object[0]);
        }
        this.data.clear();
    }
}

