/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jassa.web.api;

import com.google.gson.Gson;
import com.hp.hpl.jena.rdf.model.Model;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.aksw.jassa.sparql_path.core.SparqlServiceFactory;
import org.aksw.jassa.sparql_path.core.algorithm.ConceptPathFinder;
import org.aksw.jassa.sparql_path.core.domain.Concept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/path-finding")
public class PathFindingApi {
    @Autowired
    private SparqlServiceFactory sparqlServiceFactory;

    @GET
    @Produces(value={"application/json"})
    public String findPaths(@QueryParam(value="service-uri") String serviceUri, @QueryParam(value="default-graph-uri") List<String> defaultGraphUris, @QueryParam(value="source-element") String sourceElement, @QueryParam(value="source-var") String sourceVar, @QueryParam(value="target-element") String targetElement, @QueryParam(value="target-var") String targetVar, @QueryParam(value="js-service-uri") String joinSummaryServiceUri, @QueryParam(value="js-graph-uri") List<String> joinSummaryGraphUris, @QueryParam(value="n-paths") Integer nPaths, @QueryParam(value="max-hops") Integer maxHops) throws ClassNotFoundException, SQLException {
        Model joinSummaryModel;
        nPaths = nPaths != null ? nPaths : 3;
        maxHops = maxHops != null ? maxHops : 3;
        Concept sourceConcept = Concept.create((String)sourceElement, (String)sourceVar);
        Concept targetConcept = Concept.create((String)targetElement, (String)targetVar);
        QueryExecutionFactory sparqlService = this.sparqlServiceFactory.createSparqlService(serviceUri, defaultGraphUris);
        if (joinSummaryServiceUri != null && !joinSummaryServiceUri.isEmpty()) {
            if (joinSummaryGraphUris == null) {
                joinSummaryGraphUris = Collections.emptyList();
            }
            QueryExecutionFactory jsSparqlService = this.sparqlServiceFactory.createSparqlService(joinSummaryServiceUri, joinSummaryGraphUris);
            joinSummaryModel = ConceptPathFinder.createJoinSummary((QueryExecutionFactory)jsSparqlService);
        } else {
            joinSummaryModel = ConceptPathFinder.createDefaultJoinSummaryModel((QueryExecutionFactory)sparqlService);
        }
        List paths = ConceptPathFinder.findPaths((QueryExecutionFactory)sparqlService, (Concept)sourceConcept, (Concept)targetConcept, (int)nPaths, (int)maxHops, (Model)joinSummaryModel);
        ArrayList<String> tmp = new ArrayList<String>();
        for (org.aksw.jassa.sparql_path.core.domain.Path path : paths) {
            tmp.add(path.toPathString());
        }
        Gson gson = new Gson();
        String result = gson.toJson(tmp);
        return result;
    }
}

