/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jassa.sparql_path.utils;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementData;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementExists;
import com.hp.hpl.jena.sparql.syntax.ElementFetch;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementMinus;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementNotExists;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import java.util.ArrayList;
import java.util.List;

public class ElementTreeAnalyser
implements ElementVisitor {
    private Node defaultGraphName;
    private boolean isEmpty = true;
    private boolean canBind = false;
    private boolean mustMatchTriple = false;
    private List<Quad> quads = new ArrayList<Quad>();
    private List<Node> graphNames = new ArrayList<Node>();
    private List<ElementTreeAnalyser> optionals = new ArrayList<ElementTreeAnalyser>();
    private List<ElementTreeAnalyser> unions = new ArrayList<ElementTreeAnalyser>();
    private List<Expr> filterExprs = new ArrayList<Expr>();

    public ElementTreeAnalyser(Element element) {
        this(element, Quad.defaultGraphNodeGenerated);
    }

    public ElementTreeAnalyser(Element element, Node defaultGraphName) {
        this.defaultGraphName = defaultGraphName;
        element.visit((ElementVisitor)this);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean canBind() {
        return this.canBind;
    }

    public boolean mustMatchTriple() {
        return this.mustMatchTriple;
    }

    public List<Quad> getQuads() {
        return this.quads;
    }

    public List<ElementTreeAnalyser> getOptionals() {
        return this.optionals;
    }

    public List<Node> getGraphNames() {
        return this.graphNames;
    }

    public List<ElementTreeAnalyser> getUnions() {
        return this.unions;
    }

    public List<ElementTreeAnalyser> optionals() {
        return this.optionals;
    }

    public List<ElementTreeAnalyser> unions() {
        return this.unions;
    }

    public List<Expr> getFilterExprs() {
        return this.filterExprs;
    }

    public void visit(ElementTriplesBlock el) {
        for (Triple t : el.getPattern().getList()) {
            this.isEmpty = false;
            if (t.getSubject().isVariable() || t.getPredicate().isVariable() || t.getObject().isVariable()) {
                this.canBind = true;
            }
            if (this.defaultGraphName == null) {
                Quad quad = new Quad(this.defaultGraphName, t);
                this.quads.add(quad);
            } else {
                this.quads.add(new Quad(this.defaultGraphName, t));
            }
            this.mustMatchTriple = true;
        }
    }

    public void visit(ElementFilter el) {
        this.isEmpty = false;
        this.filterExprs.add(el.getExpr());
    }

    public void visit(ElementUnion el) {
        List elements = el.getElements();
        if (elements.size() == 1) {
            ((Element)elements.get(0)).visit((ElementVisitor)this);
            return;
        }
        ArrayList<ElementTreeAnalyser> union = new ArrayList<ElementTreeAnalyser>();
        boolean allMustMatchTriple = true;
        boolean anyMustMatchTriple = false;
        for (Element element : el.getElements()) {
            ElementTreeAnalyser analyser = new ElementTreeAnalyser(element, this.defaultGraphName);
            if (analyser.isEmpty()) {
                allMustMatchTriple = false;
                continue;
            }
            this.isEmpty = false;
            if (analyser.canBind()) {
                this.canBind = true;
            }
            allMustMatchTriple = allMustMatchTriple && analyser.mustMatchTriple();
            anyMustMatchTriple = anyMustMatchTriple || analyser.mustMatchTriple();
            union.add(analyser);
        }
        if (anyMustMatchTriple && allMustMatchTriple) {
            this.mustMatchTriple = true;
        }
        if (!union.isEmpty()) {
            this.unions.addAll(union);
        }
    }

    public void visit(ElementOptional el) {
        ElementTreeAnalyser optional = new ElementTreeAnalyser(el.getOptionalElement(), this.defaultGraphName);
        if (optional.isEmpty() || !optional.canBind()) {
            return;
        }
        this.isEmpty = false;
        this.canBind = true;
        this.optionals.add(optional);
    }

    public void visit(ElementGroup el) {
        this.recurse(el.getElements());
    }

    public void visit(ElementNamedGraph el) {
        this.isEmpty = false;
        ElementTreeAnalyser analyser = new ElementTreeAnalyser(el.getElement(), el.getGraphNameNode());
        if (!analyser.mustMatchTriple()) {
            this.graphNames.add(el.getGraphNameNode());
        }
        if (el.getGraphNameNode().isVariable() || analyser.canBind()) {
            this.canBind = true;
        }
        for (Quad quad : analyser.getQuads()) {
            this.quads.add(new Quad(el.getGraphNameNode(), quad.asTriple()));
        }
        this.quads.addAll(analyser.getQuads());
        this.graphNames.addAll(analyser.getGraphNames());
        this.optionals.addAll(analyser.getOptionals());
        this.unions.addAll(analyser.getUnions());
        this.filterExprs.addAll(analyser.getFilterExprs());
    }

    private void recurse(List<Element> elements) {
        for (Element element : elements) {
            element.visit((ElementVisitor)this);
        }
    }

    public void visit(ElementPathBlock el) {
        List triplePaths = el.getPattern().getList();
        for (TriplePath triplePath : triplePaths) {
            Triple triple = triplePath.asTriple();
            Quad quad = new Quad(this.defaultGraphName, triple);
            this.quads.add(quad);
        }
    }

    public void visit(ElementAssign el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementBind el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementData el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementDataset el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementExists el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementNotExists el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementMinus el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementService el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementFetch el) {
        throw new RuntimeException("Not implemented");
    }

    public void visit(ElementSubQuery el) {
        throw new RuntimeException("Not implemented");
    }
}

