/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jassa.sparql_path.core.algorithm;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_OneOf;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.PatternVars;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jassa.sparql_path.core.PathConstraint;
import org.aksw.jassa.sparql_path.core.VocabPath;
import org.aksw.jassa.sparql_path.core.algorithm.GraphPathComparator;
import org.aksw.jassa.sparql_path.core.domain.Concept;
import org.aksw.jassa.sparql_path.core.domain.Path;
import org.aksw.jassa.sparql_path.core.domain.Step;
import org.aksw.jassa.sparql_path.utils.QueryExecutionUtils;
import org.aksw.jassa.sparql_path.utils.QueryGenerationUtils;
import org.aksw.jassa.sparql_path.utils.VarUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.jena_sparql_api.utils.GeneratorBlacklist;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.GraphPathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptPathFinder {
    private static final Logger logger = LoggerFactory.getLogger(ConceptPathFinder.class);

    public static ResultSet getPropertyAdjacency(QueryExecutionFactory qef) {
        String queryStr = "Select Distinct ?x ?y { ?a ?x ?b . ?b ?y ?c }";
        QueryExecution qe = qef.createQueryExecution(queryStr);
        ResultSet result = qe.execSelect();
        return result;
    }

    public static Model createJoinSummary(QueryExecutionFactory qef) {
        QueryExecution qe = qef.createQueryExecution("Select ?x ?y { ?x <" + VocabPath.joinsWith.getURI() + "> ?y }");
        ResultSet rs = qe.execSelect();
        Model result = ConceptPathFinder.processJoinSummaryQuery(rs);
        return result;
    }

    public static Model createDefaultJoinSummaryModel(QueryExecutionFactory qef) {
        ResultSet rs = ConceptPathFinder.getPropertyAdjacency(qef);
        Model result = ConceptPathFinder.processJoinSummaryQuery(rs);
        return result;
    }

    public static Model processJoinSummaryQuery(ResultSet rs) {
        Model joinSummaryModel = ModelFactory.createDefaultModel();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            Resource x = qs.getResource("x");
            Resource y = qs.getResource("y");
            joinSummaryModel.add(x, VocabPath.joinsWith, (RDFNode)y);
        }
        logger.debug("Join summary model contains " + joinSummaryModel.size() + " triples");
        return joinSummaryModel;
    }

    public static List<Path> findPaths(QueryExecutionFactory qef, Concept sourceConcept, Concept tmpTargetConcept, int nPaths, int maxHops) {
        Model joinSummaryModel = ConceptPathFinder.createDefaultJoinSummaryModel(qef);
        List<Path> result = ConceptPathFinder.findPaths(qef, sourceConcept, tmpTargetConcept, nPaths, maxHops, joinSummaryModel);
        return result;
    }

    public static List<Path> findPaths(QueryExecutionFactory qef, Concept sourceConcept, Concept tmpTargetConcept, int nPaths, int maxHops, Model joinSummaryModel) {
        Concept propertyConcept;
        Concept targetConcept = tmpTargetConcept.makeDistinctFrom(sourceConcept);
        logger.debug("Distinguished target concept: " + targetConcept);
        if (sourceConcept.isSubjectConcept()) {
            List<Element> elements = sourceConcept.getElements();
            ElementTriplesBlock etb = (ElementTriplesBlock)elements.get(0);
            Triple triple = etb.getPattern().get(0);
            Var s = (Var)triple.getSubject();
            Var p = (Var)triple.getPredicate();
            ElementFilter pFilter = new ElementFilter((Expr)new E_Equals((Expr)new ExprVar(p), (Expr)NodeValue.makeNode((Node)RDF.type.asNode())));
            Var o = (Var)triple.getObject();
            ExprList oExprs = new ExprList();
            oExprs.add((Expr)NodeValue.makeNode((Node)RDF.Property.asNode()));
            oExprs.add((Expr)NodeValue.makeNode((Node)OWL.DatatypeProperty.asNode()));
            oExprs.add((Expr)NodeValue.makeNode((Node)OWL.ObjectProperty.asNode()));
            ElementFilter oFilter = new ElementFilter((Expr)new E_OneOf((Expr)new ExprVar(o), oExprs));
            ArrayList<Element> newElements = new ArrayList<Element>();
            newElements.add((Element)etb);
            newElements.add((Element)pFilter);
            newElements.add((Element)oFilter);
            propertyConcept = new Concept(newElements, s);
        } else {
            propertyConcept = QueryGenerationUtils.createPropertyQuery(sourceConcept);
        }
        Query propertyQuery = propertyConcept.asQuery();
        logger.debug("Property query: " + propertyQuery);
        List<Node> nodes = QueryExecutionUtils.executeList(qef, propertyQuery);
        logger.debug("Retrieved " + nodes.size() + " properties");
        for (Node node : nodes) {
            if (node.getURI().startsWith("http://dbpedia.org/property/")) continue;
            Triple triple = new Triple(VocabPath.start.asNode(), VocabPath.joinsWith.asNode(), node);
            Statement stmt = joinSummaryModel.asStatement(triple);
            joinSummaryModel.add(stmt);
        }
        QueryExecutionFactoryModel qefMeta = new QueryExecutionFactoryModel(joinSummaryModel);
        Concept targetCandidateConcept = PathConstraint.getPathConstraintsSimple(targetConcept);
        Query targetCandidateQuery = targetCandidateConcept.asQuery();
        logger.debug("TargetCandidateQuery: " + targetCandidateQuery);
        List<Node> candidates = QueryExecutionUtils.executeList((QueryExecutionFactory)qefMeta, targetCandidateQuery);
        logger.debug("Got " + candidates.size() + " candidates: " + candidates);
        Node startVertex = VocabPath.start.asNode();
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)startVertex);
        StmtIterator itStmt = joinSummaryModel.listStatements(null, VocabPath.joinsWith, (RDFNode)null);
        while (itStmt.hasNext()) {
            Statement stmt = (Statement)itStmt.next();
            Node s = stmt.getSubject().asNode();
            Node o = stmt.getObject().asNode();
            graph.addVertex((Object)s);
            graph.addVertex((Object)o);
            graph.addEdge((Object)s, (Object)o);
        }
        logger.debug("Graph Metrics: " + graph.vertexSet().size() + " vertices, " + graph.edgeSet().size() + " edges; based on (at least) " + joinSummaryModel.size() + " triples");
        ArrayList<GraphPath> candidateGraphPaths = new ArrayList<GraphPath>();
        int i = 0;
        for (Node candidate : candidates) {
            logger.debug("Processing candidate " + ++i + "/" + candidates.size() + ": " + candidate + " (nPaths = " + nPaths + ", maxHops = " + maxHops + ")");
            if (startVertex.equals((Object)candidate)) {
                GraphPath graphPath = new GraphPathImpl((Graph)graph, (Object)startVertex, (Object)candidate, new ArrayList(), 0.0);
                candidateGraphPaths.add(graphPath);
                continue;
            }
            DijkstraShortestPath dijkstraShortestPath = new DijkstraShortestPath((Graph)graph, (Object)startVertex, (Object)candidate);
            GraphPath tmp = dijkstraShortestPath.getPath();
            if (tmp == null) continue;
            candidateGraphPaths.add(tmp);
        }
        Collections.sort(candidateGraphPaths, new GraphPathComparator());
        ArrayList<Path> paths = new ArrayList<Path>();
        for (GraphPath graphPath : candidateGraphPaths) {
            Node current = (Node)graphPath.getStartVertex();
            ArrayList<Step> steps = new ArrayList<Step>();
            for (DefaultEdge edge : graphPath.getEdgeList()) {
                boolean isInverse;
                Node source = (Node)graph.getEdgeSource((Object)edge);
                Node target = (Node)graph.getEdgeTarget((Object)edge);
                if (current.equals((Object)source)) {
                    current = target;
                    isInverse = false;
                } else if (current.equals((Object)target)) {
                    current = source;
                    isInverse = true;
                } else {
                    throw new RuntimeException("Should not happen");
                }
                String string = current.getURI();
                Step step = new Step(string, isInverse);
                steps.add(step);
            }
            Path path = new Path(steps);
            paths.add(path);
        }
        HashSet<String> varNames = new HashSet<String>();
        varNames.addAll(VarUtils.getVarNames(PatternVars.vars((Element)sourceConcept.getElement())));
        varNames.addAll(VarUtils.getVarNames(PatternVars.vars((Element)targetConcept.getElement())));
        GeneratorBlacklist generator = GeneratorBlacklist.create((Generator)Gensym.create((String)"v"), varNames);
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : paths) {
            List<Element> pathElements = Path.pathToElements(path, sourceConcept.getVar(), targetConcept.getVar(), (Generator)generator);
            ArrayList<Object> tmp = new ArrayList<Object>();
            if (!sourceConcept.isSubjectConcept()) {
                tmp.addAll(sourceConcept.getElements());
            }
            if (!targetConcept.isSubjectConcept()) {
                tmp.addAll(targetConcept.getElements());
            }
            tmp.addAll(pathElements);
            if (pathElements.isEmpty() && !sourceConcept.getVar().equals((Object)targetConcept.getVar())) {
                tmp.add(new ElementFilter((Expr)new E_Equals((Expr)new ExprVar(sourceConcept.getVar()), (Expr)new ExprVar(targetConcept.getVar()))));
            }
            ElementGroup group = new ElementGroup();
            for (Element element : tmp) {
                group.addElement(element);
            }
            Query query = new Query();
            query.setQueryAskType();
            query.setQueryPattern((Element)group);
            logger.debug("Verifying candidate with query: " + query);
            QueryExecution queryExecution = qef.createQueryExecution(query);
            boolean isCandidate = queryExecution.execAsk();
            logger.debug("Verification result is [" + isCandidate + "] for " + query);
            if (!isCandidate) continue;
            result.add(path);
        }
        return result;
    }

    public static Model createModel(List<Path> paths) {
        Model result = ModelFactory.createDefaultModel();
        Resource Path2 = ResourceFactory.createResource((String)"http://ns.aksw.org/jassa/ontology/Path");
        boolean i = false;
        for (Path path : paths) {
            String pathStr = path.toPathString();
            Resource s = result.createResource("http://example.org/" + StringUtils.urlEncode((String)pathStr));
            Literal o = result.createLiteral(pathStr);
            result.add(s, RDF.type, (RDFNode)Path2);
            result.add(s, RDFS.label, (RDFNode)o);
        }
        return result;
    }
}

