/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jassa.sparql_path.core.domain;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aksw.jassa.sparql_path.core.domain.Step;

public class Path {
    private List<Step> steps;

    public Path() {
        this(new ArrayList<Step>());
    }

    public Path(List<Step> steps) {
        this.steps = steps;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.steps == null ? 0 : this.steps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return !(this.steps == null ? other.steps != null : !this.steps.equals(other.steps));
    }

    public String toString() {
        return "Path [steps=" + this.steps + "]";
    }

    public static List<Element> pathToElements(Path path, Var start, Var end, Generator generator) {
        ArrayList<Element> result = new ArrayList<Element>();
        ElementTriplesBlock tmp = new ElementTriplesBlock();
        List<Triple> triples = Path.pathToTriples(path, start, end, generator);
        if (!triples.isEmpty()) {
            for (Triple triple : triples) {
                tmp.addTriple(triple);
            }
            result.add((Element)tmp);
        }
        return result;
    }

    public static List<Triple> pathToTriples(Path path, Var start, Var end, Generator generator) {
        ArrayList<Triple> result = new ArrayList<Triple>();
        Var a = start;
        Iterator<Step> it = path.getSteps().iterator();
        while (it.hasNext()) {
            Step step = it.next();
            Var b = it.hasNext() ? Var.alloc((String)generator.next()) : end;
            Triple t = !step.isInverse() ? new Triple((Node)a, Node.createURI((String)step.getPropertyName()), (Node)b) : new Triple((Node)b, Node.createURI((String)step.getPropertyName()), (Node)a);
            result.add(t);
            a = b;
        }
        return result;
    }

    public String toPathString() {
        String result = "";
        for (Step step : this.steps) {
            if (!result.isEmpty()) {
                result = result + " ";
            }
            if (step.isInverse()) {
                result = result + "<";
            }
            result = result + step.getPropertyName();
        }
        return result;
    }
}

