/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.geiser.service.discovery;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import java.util.Map;
import org.aksw.geiser.service.discovery.ServiceDiscoveryRequest;
import org.aksw.geiser.service.discovery.ServiceDiscoveryResponse;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public abstract class AbstractServiceDiscoveryReceiver {
    private static final Logger log = LoggerFactory.getLogger(AbstractServiceDiscoveryReceiver.class);
    protected static JsonSchemaGenerator generator = new JsonSchemaGenerator(new ObjectMapper());

    @Bean
    public org.springframework.amqp.core.Queue serviceDiscoveryRequestQueue() {
        return new org.springframework.amqp.core.Queue("service.discovery.request", false, false, true);
    }

    @RabbitListener(bindings={@QueueBinding(exchange=@Exchange(value="service.discovery.request", type="topic"), value=@Queue)})
    public ServiceDiscoveryResponse handleServiceDiscoveryRequest(ServiceDiscoveryRequest request, @Headers Map<String, Object> headers) {
        ServiceDiscoveryResponse responseBean = new ServiceDiscoveryResponse();
        responseBean.service = this.getServiceName();
        responseBean.type = this.getServiceType();
        try {
            responseBean.requestSchema = generator.generateSchema(this.getRequestMessageClass());
            responseBean.requestSchema.setDescription(this.getRequestMessageDescription());
            if (this.getResponseMessageClass() != null) {
                responseBean.responseSchema = generator.generateSchema(this.getResponseMessageClass());
                responseBean.responseSchema.setDescription(this.getResponseMessageDescription());
            }
        }
        catch (JsonMappingException e) {
            log.warn("failed to generate json schema for hello message bean:", (Throwable)e);
        }
        return responseBean;
    }

    protected boolean matchesRequest(ServiceDiscoveryRequest request) {
        boolean matchesServiceName = request.serviceQuery == null ? true : FilenameUtils.wildcardMatch((String)this.getServiceName(), (String)request.serviceQuery);
        boolean matchesType = request.typeQuery == null ? true : FilenameUtils.wildcardMatch((String)this.getServiceType(), (String)request.typeQuery);
        return matchesServiceName && matchesType;
    }

    public abstract String getServiceName();

    public abstract String getServiceType();

    public abstract Class<?> getRequestMessageClass();

    public abstract String getRequestMessageDescription();

    public Class<?> getResponseMessageClass() {
        return null;
    }

    public String getResponseMessageDescription() {
        return null;
    }
}

