/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.geiser.configuration;

import org.aksw.geiser.configuration.RabbitMqConfiguration;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableRabbit
public class RabbitListenerConfiguration
extends RabbitMqConfiguration {
    @Value(value="${amqp_consumers_concurrent:3}")
    private Integer amqpConcurrentConsumers;
    @Value(value="${amqp_consumers_max:10}")
    private Integer amqpMaxConcurrentConsumers;

    @Bean
    public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory() {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(this.connectionFactory());
        factory.setConcurrentConsumers(this.amqpConcurrentConsumers);
        factory.setMaxConcurrentConsumers(this.amqpMaxConcurrentConsumers);
        return factory;
    }
}

