/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.aksw.faraday_cage.engine.ThreadlocalInheritingThreadPoolExecutor;

public class ThreadlocalInheritingCompletableFuture<T>
extends CompletableFuture<T> {
    private static final int PARALLELISM;
    private static final String DEER_PARALLELISM_LEVEL = "org.aksw.deer.parallelism";
    private static final Executor executor;

    public static <U> CompletableFuture<U> completedFuture(U value) {
        ThreadlocalInheritingCompletableFuture<U> x = new ThreadlocalInheritingCompletableFuture<U>();
        x.complete(value);
        return x;
    }

    @Override
    public Executor defaultExecutor() {
        return executor;
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new ThreadlocalInheritingCompletableFuture<T>();
    }

    static {
        int parallelism = Runtime.getRuntime().availableProcessors();
        if (System.getProperty(DEER_PARALLELISM_LEVEL) != null) {
            parallelism = Integer.parseInt(System.getProperty(DEER_PARALLELISM_LEVEL));
        }
        PARALLELISM = parallelism;
        executor = ThreadlocalInheritingThreadPoolExecutor.get(PARALLELISM);
    }
}

