/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.faraday_cage.engine.Plugin;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginManager;

public class PluginFactory<U extends Plugin> {
    private PluginManager pluginManager;
    private ExtensionFactory factory;
    private Map<Resource, Class<?>> classMap;
    private Class<U> clazz;
    private Resource type;

    public PluginFactory(Class<U> clazz, PluginManager pluginManager, Resource type) {
        this.clazz = clazz;
        this.pluginManager = pluginManager;
        this.factory = pluginManager.getExtensionFactory();
        this.type = type;
        this.classMap = this.createClassMap();
    }

    private Map<Resource, Class<?>> createClassMap() {
        HashMap classMap = new HashMap();
        this.pluginManager.getExtensions(this.clazz).forEach(plugin -> classMap.put(plugin.getType(), plugin.getClass()));
        return classMap;
    }

    public U create(Resource id) {
        Resource type = Plugin.getImplementationType(id);
        U u = this.getInstance(type);
        u.initPluginId(id);
        return u;
    }

    public U getImplementationOf(Resource type) {
        U u = this.getInstance(type);
        u.initPluginId(type);
        return u;
    }

    private U getInstance(Resource type) {
        if (!this.classMap.containsKey(type)) {
            throw new RuntimeException(this.clazz.getName() + " implementation for declaration \"" + type + "\" could not be found.");
        }
        Object o = this.factory.create(this.classMap.get(type));
        if (!this.clazz.isInstance(o)) {
            throw new RuntimeException("ExecutionNode \"" + type + "\" required as " + this.clazz.getName() + ", but has type " + o.getClass().getName());
        }
        return (U)((Plugin)this.clazz.cast(o));
    }

    public final List<Resource> listAvailable() {
        Model resultModel = ModelFactory.createDefaultModel();
        return this.classMap.keySet().stream().map(r -> resultModel.createResource(r.getURI())).peek(r -> r.addProperty(RDFS.subClassOf, (RDFNode)this.type)).collect(Collectors.toList());
    }
}

