/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.ArrayList;
import java.util.List;
import org.aksw.faraday_cage.engine.ExecutionNode;

public class ExecutionGraph<T> {
    protected List<ExecutionNode<T>> ops;
    protected int[][] entries;

    public ExecutionGraph(int size) {
        this.ops = new ArrayList<ExecutionNode<T>>(size);
        for (int i = 0; i < size; ++i) {
            this.ops.add(null);
        }
        this.entries = new int[size][2];
    }

    public void addRow(int i, ExecutionNode<T> op, int[] row) {
        this.entries[i] = row;
        this.ops.set(i, op);
    }

    public int getSize() {
        return this.entries.length;
    }

    public ExecutionNode<T> getNode(int i) {
        return this.ops.get(i);
    }

    public int[] getRow(int i) {
        return this.entries[i];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.entries.length; ++i) {
            sb.append(this.ops.get(i).getId());
            sb.append(" ");
            sb.append(this.entries[i][0]);
            sb.append(" ");
            sb.append(this.entries[i][1]);
            sb.append("\n");
        }
        return sb.toString();
    }
}

