/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.List;
import java.util.Objects;
import org.aksw.faraday_cage.decorator.ExecutionNodeWrapper;
import org.aksw.faraday_cage.engine.DecoratedExecutionNodeFactory;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.Parameterized;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.validation.ValidationUtil;
import org.topbraid.shacl.vocabulary.SH;

class ConfigurationGraphValidator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationGraphValidator.class);
    private static final Model baseValidationModel = JenaUtil.createMemoryModel();
    private final DecoratedExecutionNodeFactory<? extends ExecutionNode<?>, ? extends ExecutionNodeWrapper<? extends ExecutionNode<?>, ?>, ?> factory;
    private final List<Resource> allPluginTypes;

    ConfigurationGraphValidator(DecoratedExecutionNodeFactory<? extends ExecutionNode<?>, ? extends ExecutionNodeWrapper<? extends ExecutionNode<?>, ?>, ?> factory) {
        this.factory = factory;
        this.allPluginTypes = factory.listAvailable();
        this.allPluginTypes.addAll(factory.getWrapperFactory().listAvailable());
    }

    private static Model getBaseValidationModel() {
        Model m = JenaUtil.createMemoryModel();
        m.add(baseValidationModel);
        return m;
    }

    Model getValidationModelFor(Resource id) {
        ExecutionNodeWrapper<? extends ExecutionNode<?>, ?> implementation;
        try {
            implementation = this.factory.getImplementationOf(id);
        }
        catch (RuntimeException e) {
            implementation = this.factory.getWrapperFactory().getImplementationOf(id);
        }
        if (implementation instanceof Parameterized) {
            return ((Parameterized)((Object)implementation)).createParameterMap().getValidationModel();
        }
        return ModelFactory.createDefaultModel();
    }

    Model getFullValidationModel() {
        Model validationModel = ConfigurationGraphValidator.getBaseValidationModel();
        this.allPluginTypes.stream().map(this::getValidationModelFor).forEach(arg_0 -> ((Model)validationModel).add(arg_0));
        return validationModel;
    }

    Resource validate(Model configGraph) {
        Model validationModel = this.getFullValidationModel();
        this.allPluginTypes.stream().map(Resource::listProperties).forEach(arg_0 -> ((Model)configGraph).add(arg_0));
        return ValidationUtil.validateModel((Model)configGraph, (Model)validationModel, (boolean)true);
    }

    static boolean isConformingValidationReport(Resource validationReport) {
        return Objects.nonNull(validationReport) && validationReport.getProperty(SH.conforms).getBoolean();
    }

    static {
        baseValidationModel.read(ConfigurationGraphValidator.class.getResourceAsStream("/shacl/fcage:ExecutionNode.ttl"), null, "TURTLE");
    }
}

