/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.faraday_cage.engine.ExecutionGraph;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.InvalidExecutionGraphException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdjacencyMatrix {
    private static final Logger logger = LoggerFactory.getLogger(AdjacencyMatrix.class);
    private final int[][][] rows;

    AdjacencyMatrix(int n) {
        this.rows = new int[n][n][0];
    }

    AdjacencyMatrix(AdjacencyMatrix other) {
        this.rows = other.rows;
    }

    void addEdge(int from, int fromPort, int to, int toPort) {
        int k = this.rows[from][to].length;
        this.rows[from][to] = Arrays.copyOf(this.rows[from][to], k + 2);
        this.rows[from][to][k] = fromPort;
        this.rows[from][to][k + 1] = toPort;
    }

    <T> ExecutionGraph<T> compileCanonicalForm(List<ExecutionNode<T>> ops) {
        int[] canonicalIndexing = this.getCanonicalIndexing();
        ArrayList<ExecutionNode<T>> canonicalOps = new ArrayList<ExecutionNode<T>>(ops.size());
        for (int i = 0; i < this.rows.length; ++i) {
            canonicalOps.add(null);
        }
        AdjacencyMatrix canonicalForm = new AdjacencyMatrix(this.rows.length);
        for (int i = 0; i < this.rows.length; ++i) {
            int k = this.rows.length - 1 - canonicalIndexing[i];
            canonicalOps.set(k, ops.get(i));
            for (int j = 0; j < this.rows.length; ++j) {
                int l = this.rows.length - 1 - canonicalIndexing[j];
                canonicalForm.rows[k][l] = this.rows[i][j];
            }
        }
        int[] inDegrees = new int[this.rows.length];
        int[] outDegrees = new int[this.rows.length];
        for (int i = 0; i < this.rows.length; ++i) {
            for (int j = 0; j < this.rows.length; ++j) {
                int n = i;
                inDegrees[n] = inDegrees[n] + canonicalForm.rows[j][i].length / 2;
                for (int k = 0; k < canonicalForm.rows[i][j].length; k += 2) {
                    outDegrees[i] = Math.max(outDegrees[i], canonicalForm.rows[i][j][k] + 1);
                }
            }
        }
        ExecutionGraph executionGraph = new ExecutionGraph(canonicalOps.size());
        for (int i = this.rows.length - 1; i >= 0; --i) {
            int[] columnRow = new int[2 + inDegrees[i] * 2];
            columnRow[0] = inDegrees[i];
            columnRow[1] = outDegrees[i];
            for (int j = 0; j < this.rows.length; ++j) {
                int n = canonicalForm.rows[j][i].length;
                for (int k = 0; k < n; k += 2) {
                    columnRow[2 + canonicalForm.rows[j][i][k + 1] * 2] = this.rows.length - j - 1;
                    columnRow[2 + canonicalForm.rows[j][i][k + 1] * 2 + 1] = canonicalForm.rows[j][i][k];
                }
            }
            executionGraph.addRow(this.rows.length - i - 1, (ExecutionNode)canonicalOps.get(i), columnRow);
        }
        logger.info("\n{}", executionGraph);
        return executionGraph;
    }

    private int[] getCanonicalIndexing() {
        int i;
        AdjacencyMatrix a = this;
        int[] maxPathLength = new int[this.rows.length];
        int[] canonicalIndexing = new int[this.rows.length];
        List<Integer> leafs = this.getLeafs();
        logger.trace(leafs.toString());
        for (int n = 1; n <= this.rows.length; ++n) {
            logger.trace("\n{}", (Object)a);
            int[][][] x = a.rows;
            for (i = 0; i < this.rows.length; ++i) {
                if (x[i][i].length == 0) continue;
                throw new InvalidExecutionGraphException("The given graph contains a cycle!");
            }
            boolean stop = true;
            for (int leaf : leafs) {
                for (int j = 0; j < this.rows.length; ++j) {
                    if (x[leaf][j].length == 0) continue;
                    maxPathLength[j] = n;
                    stop = false;
                }
            }
            if (stop) break;
            a = this.matrixProduct(a);
        }
        int l = 0;
        for (int k = 0; k < this.rows.length && l < this.rows.length; ++k) {
            for (i = 0; i < this.rows.length; ++i) {
                if (maxPathLength[i] != k) continue;
                canonicalIndexing[i] = l++;
            }
        }
        logger.trace("\n{}", (Object)Arrays.toString(maxPathLength));
        logger.trace("\n{}", (Object)Arrays.toString(canonicalIndexing));
        return canonicalIndexing;
    }

    private AdjacencyMatrix matrixProduct(AdjacencyMatrix other) {
        AdjacencyMatrix result = new AdjacencyMatrix(this.rows.length);
        int[][][] a = this.rows;
        int[][][] b = other.rows;
        int[][][] c = result.rows;
        for (int i = 0; i < c.length; ++i) {
            block1: for (int j = 0; j < c.length; ++j) {
                for (int k = 0; k < c.length; ++k) {
                    if ((a[i][k].length & b[k][j].length) == 0) continue;
                    c[i][j] = new int[2];
                    continue block1;
                }
            }
        }
        return result;
    }

    private List<Integer> getLeafs() {
        ArrayList<Integer> leafs = new ArrayList<Integer>();
        for (int i = 0; i < this.rows.length; ++i) {
            boolean leaf = true;
            for (int j = 0; j < this.rows.length; ++j) {
                if (this.rows[j][i].length == 0) continue;
                leaf = false;
                break;
            }
            if (!leaf) continue;
            leafs.add(i);
        }
        return leafs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rows.length; ++i) {
            for (int j = 0; j < this.rows.length; ++j) {
                sb.append(this.rows[i][j].length / 2);
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

