/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.validation;

import java.util.Arrays;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.topbraid.shacl.vocabulary.SH;

public class ValidationShapeBuilder
implements Supplier<Model> {
    private Model model = ModelFactory.createDefaultModel();
    private Resource self = this.model.createResource();

    static ValidationShapeBuilder create() {
        return new ValidationShapeBuilder();
    }

    private ValidationShapeBuilder() {
    }

    public ValidationShapeBuilder xone(UnaryOperator<ValidationShapeBuilder> ... shapes) {
        return this.group(ResourceFactory.createProperty((String)"http://www.w3.org/ns/shacl#xone"), shapes);
    }

    public ValidationShapeBuilder and(UnaryOperator<ValidationShapeBuilder> ... shapes) {
        return this.group(SH.and, shapes);
    }

    public ValidationShapeBuilder or(UnaryOperator<ValidationShapeBuilder> ... shapes) {
        return this.group(SH.or, shapes);
    }

    private ValidationShapeBuilder group(Property groupingProperty, UnaryOperator<ValidationShapeBuilder> ... shapes) {
        Arrays.stream(shapes).forEach(op -> {
            Resource other = ((ValidationShapeBuilder)op.apply(new ValidationShapeBuilder())).getSelf();
            this.model.add(this.self, groupingProperty, (RDFNode)other);
            this.model.add(other.getModel());
        });
        return this;
    }

    private Resource getSelf() {
        return this.self;
    }

    @Override
    public Model get() {
        return this.model;
    }
}

