/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.util;

import org.aksw.faraday_cage.engine.ExecutionGraph;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.Parameterized;
import org.aksw.faraday_cage.vocabulary.FCAGE;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;

public class ExecutionGraphSerializer {
    public static Model serialize(ExecutionGraph executionGraph) {
        int n = executionGraph.getSize();
        Model serialized = ModelFactory.createDefaultModel();
        for (int i = 0; i < n; ++i) {
            int[] row = executionGraph.getRow(i);
            Resource[] inputDefs = new Resource[row[0]];
            if (row[0] > 0) {
                for (int j = 2; j < 2 + row[0] * 2; j += 2) {
                    Resource resource = serialized.createResource();
                    inputDefs[j / 2 - 1] = resource;
                    resource.addProperty(FCAGE.fromNode, (RDFNode)executionGraph.getNode(row[j]).getId()).addProperty(FCAGE.fromPort, String.valueOf(row[j + 1]), (RDFDatatype)XSDDatatype.XSDinteger);
                }
            }
            ExecutionNode node = executionGraph.getNode(i);
            Resource nodeResource = node.getId().inModel(serialized).addProperty(RDF.type, (RDFNode)node.getType());
            if (inputDefs.length > 0) {
                nodeResource.addProperty(FCAGE.hasInput, (RDFNode)serialized.createList((RDFNode[])inputDefs));
            }
            if (!(node instanceof Parameterized)) continue;
            Parameterized pNode = (Parameterized)((Object)node);
            serialized.add(pNode.getParameterMap().parametrize(nodeResource));
        }
        return serialized;
    }
}

