/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;

public class ValidatableParameterMap {
    private final Model validationModel;
    private final List<Property> declaredProperties;
    private final Multimap<Property, RDFNode> rootMap;
    private final Model backingModel = ModelFactory.createDefaultModel();
    private boolean initialized = false;

    public static ValidatableParameterMap emptyInstance() {
        return new ValidatableParameterMap(List.of(), ModelFactory.createDefaultModel());
    }

    public static Builder builder() {
        return new Builder();
    }

    private ValidatableParameterMap(List<Property> declaredProperties, Model validationModel) {
        this.validationModel = validationModel;
        this.declaredProperties = declaredProperties;
        this.rootMap = ArrayListMultimap.create((int)declaredProperties.size(), (int)1);
    }

    public ValidatableParameterMap populate(Resource root) {
        this.checkWritable();
        this.declaredProperties.stream().filter(arg_0 -> ((Resource)root).hasProperty(arg_0)).map(arg_0 -> ((Resource)root).listProperties(arg_0)).forEach(this::add);
        return this;
    }

    public ValidatableParameterMap add(StmtIterator it) {
        this.checkWritable();
        it.forEachRemaining(stmt -> this.add(stmt.getPredicate(), stmt.getObject()));
        return this;
    }

    public ValidatableParameterMap add(Property p, RDFNode node) {
        this.checkWritable();
        ArrayDeque<RDFNode> stack = new ArrayDeque<RDFNode>();
        HashSet<Resource> visited = new HashSet<Resource>();
        this.rootMap.put((Object)p.inModel(this.backingModel), (Object)node.inModel(this.backingModel));
        if (node.getModel() != null) {
            stack.push(node);
            while (!stack.isEmpty()) {
                RDFNode n = (RDFNode)stack.pop();
                if (!n.isResource() || visited.contains(n.asResource())) continue;
                Resource r = n.asResource();
                r.listProperties().forEachRemaining(stmt -> {
                    this.backingModel.add(stmt);
                    stack.push(stmt.getObject());
                });
                visited.add(r);
            }
        }
        return this;
    }

    public ValidatableParameterMap init() {
        this.checkWritable();
        this.initialized = true;
        return this;
    }

    public Stream<RDFNode> listPropertyObjects(Property p) {
        this.checkReadable();
        return this.rootMap.get((Object)p).stream();
    }

    public Optional<RDFNode> getOptional(Property p) {
        this.checkReadable();
        return this.listPropertyObjects(p).findFirst();
    }

    public RDFNode get(Property p) {
        this.checkReadable();
        return this.listPropertyObjects(p).findFirst().get();
    }

    public Model parametrize(Resource exNode) {
        this.checkReadable();
        Model parameterModel = ModelFactory.createDefaultModel().add(this.backingModel);
        Resource r = exNode.inModel(parameterModel);
        this.rootMap.forEach((p, o) -> parameterModel.add(r, p, o));
        return parameterModel;
    }

    public Model getValidationModel() {
        return this.validationModel;
    }

    private void checkWritable() {
        if (this.initialized) {
            throw new IllegalStateException("This ParameterMap has already been initialized, writing operations are therefore prohibited!");
        }
    }

    private void checkReadable() {
        if (!this.initialized) {
            throw new IllegalStateException("This ParameterMap has not yet been initialized, reading operations are therefore prohibited!");
        }
    }

    public Resource createResource() {
        this.checkWritable();
        return this.backingModel.createResource();
    }

    public Resource createResource(String url) {
        this.checkWritable();
        return this.backingModel.createResource(url);
    }

    public Literal createLiteral(String s) {
        this.checkWritable();
        return this.backingModel.createLiteral(s);
    }

    public int hashCode() {
        return this.rootMap.hashCode();
    }

    public boolean equals(Object o) {
        return this.rootMap.equals(o);
    }

    public static class Builder {
        private List<Property> propertyList = new ArrayList<Property>();
        private Model validationModel = ModelFactory.createDefaultModel();

        private Builder() {
        }

        public Builder declareProperty(Property property) {
            this.propertyList.add(property);
            return this;
        }

        public Builder declareValidationShape(Model validationShape) {
            this.validationModel.add(validationShape);
            return this;
        }

        public ValidatableParameterMap build() {
            return new ValidatableParameterMap(this.propertyList, this.validationModel);
        }
    }
}

