/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.aksw.faraday_cage.engine.FaradayCageContext;

class ThreadlocalInheritingThreadPoolExecutor
extends ForkJoinPool {
    static ThreadlocalInheritingThreadPoolExecutor get(int parallelism) {
        return new ThreadlocalInheritingThreadPoolExecutor(parallelism);
    }

    private ThreadlocalInheritingThreadPoolExecutor(int parallelism) {
        super(parallelism);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(ThreadlocalInheritingThreadPoolExecutor.wrap(command));
    }

    @Override
    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        return super.submit((Callable)ThreadlocalInheritingThreadPoolExecutor.wrap(task));
    }

    @Override
    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        return super.submit(ThreadlocalInheritingThreadPoolExecutor.wrap(task), (Object)result);
    }

    @Override
    public ForkJoinTask<?> submit(Runnable task) {
        return super.submit(ThreadlocalInheritingThreadPoolExecutor.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException("Operation not implemented.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Operation not implemented.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException("Operation not implemented.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Operation not implemented.");
    }

    private static Runnable wrap(Runnable runnable) {
        String newRunId = FaradayCageContext.getRunId();
        return () -> {
            String previousRunId = FaradayCageContext.getRunId();
            FaradayCageContext.setRunId(newRunId);
            FaradayCageContext.valueConsumer.forEach(runIdConsumer -> runIdConsumer.accept(newRunId));
            try {
                runnable.run();
            }
            finally {
                FaradayCageContext.setRunId(previousRunId);
            }
        };
    }

    private static <V> Callable<V> wrap(Callable<V> callable) {
        String newRunId = FaradayCageContext.getRunId();
        return () -> {
            Object call;
            String previousRunId = FaradayCageContext.getRunId();
            FaradayCageContext.setRunId(newRunId);
            try {
                call = callable.call();
            }
            finally {
                FaradayCageContext.setRunId(previousRunId);
            }
            return call;
        };
    }
}

